/*
 * Decompiled with CFR 0.152.
 */
package dd.ui;

import dd.sim.Proposal;
import dd.ui.GUIEvents;
import dd.ui.GameSupport;
import dd.ui.gt.ColumnGroup;
import dd.ui.gt.GroupableTableHeader;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;

public class ProposalList
extends JTable
implements PropertyChangeListener {
    private boolean reselecting = false;
    private Proposal selectedProposal = null;
    private GUIEvents ui;
    private ListTableModel proposalModel;
    private static HashMap votingPrefs;
    public static final String[] columnLabels;
    static /* synthetic */ Class class$dd$ui$ProposalList$ColoredLabel;
    static /* synthetic */ Class class$dd$ui$ProposalList$Opinion;

    public ImageIcon createImageIcon(String image) {
        return GameSupport.getImage(image + ".png");
    }

    public void makeVotingIcons() {
        votingPrefs = new HashMap();
        votingPrefs.put("I support this proposal", this.createImageIcon("yes"));
        votingPrefs.put("I do not support this proposal", this.createImageIcon("no"));
        votingPrefs.put("If", this.createImageIcon("maybe"));
        votingPrefs.put("None", GameSupport.emptyImageIcon(14, 18));
    }

    public Opinion getOpinion(Proposal proposal, int playerNumber) {
        Opinion o = new Opinion();
        ImageIcon icon = (ImageIcon)votingPrefs.get(proposal.getPlayerOpinion(this.ui.getPlayer(playerNumber)));
        o.playerColor = this.ui.getColor(playerNumber);
        if (o.playerColor.equals(Color.black)) {
            o.playerColor = Color.white;
        }
        o.toolTip = proposal.getPlayerOpinion(this.ui.getPlayer(playerNumber));
        if (icon == null) {
            if (proposal.getPlayerOpinion(this.ui.getPlayer(playerNumber)) == null) {
                icon = (ImageIcon)votingPrefs.get("None");
                o.toolTip = "No opinion";
            } else {
                icon = (ImageIcon)votingPrefs.get("If");
            }
        }
        o.iconToDisplay = icon;
        return o;
    }

    public void propertyChange(PropertyChangeEvent e) {
        this.proposalModel.repopulate();
    }

    public void refresh() {
        this.proposalModel.fireTableDataChanged();
        this.sizeCols();
    }

    private void proposalSelected(int proposalIndex) {
        this.selectedProposal = this.proposalModel.getProposal(proposalIndex);
        this.ui.setSelectedProposal(this.selectedProposal);
    }

    public void selectProposal(Proposal proposal) {
        if (proposal == null) {
            this.proposalModel.deselect();
        } else {
            this.selectedProposal = proposal;
            this.proposalModel.reselect(proposal);
        }
    }

    public Proposal getSelectedProposal() {
        return this.selectedProposal;
    }

    public void rootChanged() {
        this.ui.getRoot().getProposalRegistry().addPropertyChangeListener(this);
        this.proposalModel.repopulate();
        this.refresh();
    }

    public ProposalList(GUIEvents dlug) {
        this.ui = dlug;
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ProposalList.this.ui.proposalDoubleClicked(ProposalList.this.getSelectedProposal());
                }
            }
        });
        this.proposalModel = new ListTableModel();
        this.makeVotingIcons();
        this.setDefaultRenderer(class$dd$ui$ProposalList$ColoredLabel == null ? (class$dd$ui$ProposalList$ColoredLabel = ProposalList.class$("dd.ui.ProposalList$ColoredLabel")) : class$dd$ui$ProposalList$ColoredLabel, new ColoredLabelCellRenderer());
        this.setDefaultRenderer(class$dd$ui$ProposalList$Opinion == null ? (class$dd$ui$ProposalList$Opinion = ProposalList.class$("dd.ui.ProposalList$Opinion")) : class$dd$ui$ProposalList$Opinion, new OpinionCellRenderer());
        this.setModel(this.proposalModel);
        this.getSelectionModel().setSelectionMode(0);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (ProposalList.this.reselecting) {
                    ProposalList.this.reselecting = false;
                    return;
                }
                ProposalList.this.selectedProposal = null;
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel model = (ListSelectionModel)e.getSource();
                if (!model.isSelectionEmpty()) {
                    int selectedRow = model.getMinSelectionIndex();
                    ProposalList.this.proposalSelected(selectedRow);
                }
            }
        });
        TableColumnModel cm = this.getColumnModel();
        GroupableTableHeader gth = new GroupableTableHeader(this.getColumnModel());
        ColumnGroup opinionGroup = new ColumnGroup("Opinion Poll");
        opinionGroup.add(cm.getColumn(1));
        opinionGroup.add(cm.getColumn(2));
        opinionGroup.add(cm.getColumn(3));
        opinionGroup.add(cm.getColumn(4));
        gth.addColumnGroup(opinionGroup);
        this.setTableHeader(gth);
    }

    private void sizeCols() {
        if (this.ui == null || this.ui.getRoot() == null || this.ui.getRoot().getProposals() == null || this.ui.getRoot().getProposals().size() == 0 || this.getModel().getRowCount() < 3) {
            return;
        }
        GameSupport.sizeCols(this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        columnLabels = new String[]{"Name", "1", "2", "3", "4"};
    }

    class ListTableModel
    extends AbstractTableModel {
        private ArrayList theList = new ArrayList();
        private Proposal oldProposal;

        public Proposal getProposal(int index) {
            if (index < 0 || index > this.theList.size()) {
                return null;
            }
            return (Proposal)this.theList.get(index);
        }

        public int indexOf(Proposal proposal) {
            return this.theList.indexOf(proposal);
        }

        public void repopulate() {
            this.oldProposal = ProposalList.this.selectedProposal;
            this.theList = new ArrayList();
            this.theList.add(new Proposal("PENDING PROPOSALS"));
            List l = ProposalList.this.ui.getRoot().getCurrentProposals();
            this.theList.addAll(l);
            this.theList.add(new Proposal("FAILED PROPOSALS"));
            l = ProposalList.this.ui.getRoot().getFailedProposals();
            this.theList.addAll(l);
            ProposalList.this.proposalModel.fireTableDataChanged();
            ProposalList.this.proposalModel.reselect(this.oldProposal);
        }

        public void reselect(Proposal p) {
            ProposalList.this.reselecting = true;
            if (this.theList.contains(p)) {
                ProposalList.this.getSelectionModel().clearSelection();
                ProposalList.this.getSelectionModel().addSelectionInterval(this.theList.lastIndexOf(p), this.theList.lastIndexOf(p));
            }
            ProposalList.this.selectedProposal = p;
            ProposalList.this.ui.plistRefreshed();
        }

        public void deselect() {
            ProposalList.this.getSelectionModel().clearSelection();
            ProposalList.this.getSelectionModel().addSelectionInterval(0, 0);
        }

        public int getColumnCount() {
            return 5;
        }

        public int getRowCount() {
            return this.theList.size();
        }

        public String getColumnName(int columnIndex) {
            return columnLabels[columnIndex];
        }

        public Object getValueAt(int row, int column) {
            int listSize = this.theList.size();
            if (listSize == 0) {
                return "N/A";
            }
            if (listSize == 2) {
                return "N/A";
            }
            if (listSize <= row) {
                return "N/A";
            }
            Proposal proposal = (Proposal)this.theList.get(row);
            if (proposal.getStatus().equals("Info")) {
                if (column == 0) {
                    return new ColoredLabel(proposal);
                }
                if (column >= 1 && column <= 4) {
                    return ProposalList.this.getOpinion(proposal, 0);
                }
                return (ImageIcon)votingPrefs.get("None");
            }
            switch (column) {
                case 0: {
                    return new ColoredLabel(proposal);
                }
                case 1: {
                    return ProposalList.this.getOpinion(proposal, 1);
                }
                case 2: {
                    return ProposalList.this.getOpinion(proposal, 2);
                }
                case 3: {
                    return ProposalList.this.getOpinion(proposal, 3);
                }
                case 4: {
                    return ProposalList.this.getOpinion(proposal, 4);
                }
            }
            return "N/A";
        }

        public Class getColumnClass(int column) {
            return this.getValueAt(0, column).getClass();
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }

    class OpinionCellRenderer
    extends DefaultTableCellRenderer {
        OpinionCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, "", isSelected, hasFocus, row, column);
            this.setIcon(((Opinion)value).iconToDisplay);
            this.setHorizontalAlignment(0);
            this.setBackground(((Opinion)value).playerColor);
            this.setToolTipText(((Opinion)value).toolTip);
            return this;
        }
    }

    class ColoredLabelCellRenderer
    extends DefaultTableCellRenderer {
        ColoredLabelCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ColoredLabel cl = (ColoredLabel)value;
            super.getTableCellRendererComponent(table, cl.labelText, isSelected, hasFocus, row, column);
            this.setToolTipText(cl.toolTip);
            this.setForeground(cl.color);
            return this;
        }
    }

    class Opinion {
        public ImageIcon iconToDisplay;
        public String toolTip;
        public Color playerColor;

        Opinion() {
        }
    }

    class ColoredLabel {
        public Color color;
        public String labelText;
        public String toolTip;

        public ColoredLabel(Proposal proposal) {
            this.color = ProposalList.this.ui.getColor(proposal);
            if (proposal.getStatus().equals("Info")) {
                this.color = Color.gray;
            }
            this.labelText = proposal.getTitle();
        }

        public ColoredLabel(String text, String tip) {
            this.labelText = text;
            this.toolTip = tip;
            this.color = Color.black;
        }
    }
}

