/*
 * Decompiled with CFR 0.152.
 */
package dd.ui;

import dd.hurricane.Main;
import dd.sim.ConfigParameter;
import dd.sim.Proposal;
import dd.sim.SimObject;
import dd.ui.GUIEvents;
import dd.ui.GameSupport;
import dd.ui.ProposalVisualizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;

public class ProposalView
extends JPanel {
    private Proposal proposal;
    private JButton okButton;
    private JButton cancelButton;
    private JLabel proposalTitle;
    private JLabel proposalEconCost;
    private JLabel proposalSocialCost;
    private JLabel proposalOwner;
    private GUIEvents dlug;
    private HashMap configHolder = new HashMap();
    private HashSet componentHolder = new HashSet();
    private ItemListener update = new ItemListener(){

        public void itemStateChanged(ItemEvent e) {
            ProposalView.this.update();
        }
    };
    private boolean built = false;

    public ProposalView(GUIEvents ui) {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.dlug = ui;
        this.setDoubleBuffered(false);
    }

    public ProposalView(GUIEvents ui, Proposal newProposal) {
        this(ui);
        this.setProposal(newProposal);
    }

    public void setProposal(Proposal newProposal) {
        if (newProposal == null) {
            this.proposal = null;
            return;
        }
        this.proposal = newProposal;
    }

    public void doHelpButton() {
        this.dlug.setHelpContent("/resources/dlug/proposals/descriptions/" + this.proposal.getFamily() + ".html");
    }

    private JComponent makeComponentFor(ConfigParameter c) {
        String type = c.getType();
        if ("choice".equals(type)) {
            Iterator choices = ((ArrayList)c.getObjectAttribute("choices")).iterator();
            Iterator eCosts = ((ArrayList)c.getObjectAttribute("choiceDECost")).iterator();
            Iterator sCosts = ((ArrayList)c.getObjectAttribute("choiceDSCost")).iterator();
            String defChoice = (String)this.proposal.getObjectAttribute(c.getPropertyName());
            ButtonGroup group = new ButtonGroup();
            Box vBox = Box.createVerticalBox();
            Box hBox = Box.createHorizontalBox();
            JLabel l = new JLabel(c.getName() + ":");
            l.setEnabled(false);
            this.componentHolder.add(l);
            hBox.add(l);
            hBox.add(Box.createHorizontalGlue());
            vBox.add(hBox);
            while (choices.hasNext()) {
                hBox = Box.createHorizontalBox();
                vBox.add(hBox);
                String curChoice = (String)choices.next();
                JRadioButton rb = new JRadioButton(curChoice, curChoice.equals(defChoice));
                rb.setEnabled(false);
                rb.addItemListener(this.update);
                this.configHolder.put(rb, c);
                this.componentHolder.add(rb);
                group.add(rb);
                hBox.add(Box.createHorizontalStrut(10));
                hBox.add(rb);
                hBox.add(Box.createHorizontalGlue());
                int cost = (Integer)eCosts.next();
                l = new JLabel((cost < 0 ? "" : "+") + cost);
                l.setEnabled(false);
                this.componentHolder.add(l);
                hBox.add(l);
                l = new JLabel(GameSupport.getImage("money-icon.png"));
                l.setEnabled(false);
                this.componentHolder.add(l);
                hBox.add(l);
                hBox.add(Box.createHorizontalStrut(10));
                cost = (Integer)sCosts.next();
                l = new JLabel((cost < 0 ? "" : "+") + cost);
                l.setEnabled(false);
                this.componentHolder.add(l);
                hBox.add(l);
                l = new JLabel(GameSupport.getImage("work-icon.png"));
                l.setEnabled(false);
                this.componentHolder.add(l);
                hBox.add(l);
            }
            return vBox;
        }
        if ("boolean".equals(type)) {
            JCheckBox cb = new JCheckBox(c.getName() + "?");
            cb.setEnabled(false);
            cb.addItemListener(this.update);
            this.configHolder.put(cb, c);
            this.componentHolder.add(cb);
            cb.setSelected(this.proposal.getAttribute(c.getPropertyName(), 0.0f) != 0.0f);
            Box hBox = Box.createHorizontalBox();
            hBox.add(cb);
            hBox.add(Box.createHorizontalGlue());
            int cost = (int)c.getAttribute("dEconCost", 0.0f);
            JLabel l = new JLabel((cost < 0 ? "" : "+") + cost);
            l.setEnabled(false);
            this.componentHolder.add(l);
            hBox.add(l);
            l = new JLabel(GameSupport.getImage("money-icon.png"));
            l.setEnabled(false);
            this.componentHolder.add(l);
            hBox.add(l);
            hBox.add(Box.createHorizontalStrut(10));
            cost = (int)c.getAttribute("dSocialCost", 0.0f);
            l = new JLabel((cost < 0 ? "" : "+") + cost);
            l.setEnabled(false);
            this.componentHolder.add(l);
            hBox.add(l);
            l = new JLabel(GameSupport.getImage("work-icon.png"));
            l.setEnabled(false);
            this.componentHolder.add(l);
            hBox.add(l);
            return hBox;
        }
        return new JLabel("Unknown configParameter type: " + type);
    }

    public void makeEditView() {
        if (!this.built) {
            this.makeInterface();
        }
        this.setBorder(BorderFactory.createMatteBorder(4, 4, 4, 4, this.dlug.getColor(this.dlug.getCurrentPlayer())));
        Iterator iter = this.componentHolder.iterator();
        while (iter.hasNext()) {
            JComponent c = (JComponent)iter.next();
            c.setEnabled(true);
        }
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProposalView.this.extractInfoFromEditView();
                ProposalView.this.setBorder(null);
                ProposalView.this.makeInterface();
                ProposalView.this.dlug.editingComplete(ProposalView.this.proposal);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProposalView.this.setBorder(null);
                ProposalView.this.setProposal(null);
                ProposalView.this.dlug.setSelectedProposal(null);
            }
        });
        this.okButton.setVisible(true);
        this.cancelButton.setVisible(true);
        if (this.proposal.getConfigParameters().size() == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ProposalView.this.okButton.doClick();
                }
            });
        }
    }

    public void extractInfoFromEditView() {
        Iterator iter = this.configHolder.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            Object o = this.configHolder.get(key);
            if (!(o instanceof ConfigParameter)) continue;
            ConfigParameter c = (ConfigParameter)o;
            String type = c.getType();
            if ("choice".equals(type)) {
                JRadioButton rb = (JRadioButton)key;
                if (!rb.isSelected()) continue;
                this.proposal.configure(c, rb.getText());
                continue;
            }
            if (!"boolean".equals(type)) continue;
            JCheckBox cb = (JCheckBox)key;
            this.proposal.configure(c, cb.isSelected());
        }
    }

    public void update() {
        if (this.built) {
            this.setCosts();
            this.dlug.getMapView().setCurrentVisualizer(ProposalVisualizer.visualize(this.proposal));
            if (this.dlug.getRoot().currentlyTooCostly(this.proposal)) {
                this.okButton.setEnabled(false);
            } else {
                this.okButton.setEnabled(true);
            }
        }
    }

    private void setCosts() {
        this.extractInfoFromEditView();
        this.proposalEconCost.setText("" + (int)this.proposal.getEconCost());
        this.proposalSocialCost.setText("" + (int)this.proposal.getSocialCost());
    }

    public void makeSummaryView() {
        this.built = false;
        this.removeAll();
        this.configHolder.clear();
        this.componentHolder.clear();
        if (this.proposal == null) {
            this.add(new JLabel("No Proposal"));
            this.revalidate();
            this.repaint();
            return;
        }
        Box vBox = Box.createVerticalBox();
        this.add((Component)vBox, "West");
        JLabel label = new JLabel("<html><big>" + this.proposal.getTitle() + "</big></html>");
        label.setForeground(this.dlug.getColor(this.proposal));
        label.setAlignmentX(0.0f);
        vBox.add(label);
        Iterator iter = this.proposal.getConfigParameters().iterator();
        while (iter.hasNext()) {
            ConfigParameter c = (ConfigParameter)iter.next();
            if ("choice".equals(c.getType())) {
                label = new JLabel(c.getName() + ": " + (String)this.proposal.getObjectAttribute(c.getPropertyName()));
                label.setAlignmentX(0.0f);
                vBox.add(label);
                continue;
            }
            if (!"boolean".equals(c.getType()) || 0.0f == this.proposal.getAttribute(c.getPropertyName(), 0.0f)) continue;
            label = new JLabel(c.getName());
            label.setAlignmentX(0.0f);
            vBox.add(label);
        }
        vBox.add(Box.createVerticalStrut(8));
        Box hBox = Box.createHorizontalBox();
        hBox.setAlignmentX(0.0f);
        vBox.add(hBox);
        hBox.add(new JLabel("Cost:"));
        hBox.add(Box.createHorizontalStrut(20));
        hBox.add(new JLabel("" + (int)this.proposal.getEconCost()));
        hBox.add(new JLabel(GameSupport.getImage("money-icon.png")));
        hBox.add(Box.createHorizontalStrut(10));
        hBox.add(new JLabel("" + (int)this.proposal.getSocialCost()));
        hBox.add(new JLabel(GameSupport.getImage("work-icon.png")));
        this.revalidate();
        this.repaint();
    }

    public void makeInterface() {
        this.built = false;
        this.removeAll();
        this.configHolder.clear();
        this.componentHolder.clear();
        this.setBorder(BorderFactory.createEtchedBorder());
        if (this.proposal == null) {
            this.add(new JLabel("No Proposal"));
            this.revalidate();
            this.repaint();
            return;
        }
        if (this.proposal.getStatus().equals("Info")) {
            this.add(new JLabel(" "));
            this.revalidate();
            this.repaint();
            return;
        }
        Box vBox = Box.createVerticalBox();
        vBox.add(Box.createHorizontalStrut(365));
        Box hBox = Box.createHorizontalBox();
        this.proposalTitle = new JLabel("<html><big>" + this.proposal.getTitle() + "</big></html>");
        hBox.add(this.proposalTitle);
        hBox.add(Box.createHorizontalGlue());
        JButton helpButton = new JButton("<html><font color=\"#0000ff\"><u>Help for this Proposal</u></font></html>");
        helpButton.setHorizontalAlignment(2);
        helpButton.setCursor(new Cursor(12));
        helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProposalView.this.doHelpButton();
            }
        });
        this.componentHolder.add(this.proposalTitle);
        vBox.add(hBox);
        hBox = Box.createHorizontalBox();
        hBox.add(helpButton);
        vBox.add(hBox);
        if (this.proposal.getConfigParameters().size() > 0) {
            Iterator iter = this.proposal.getConfigParameters().iterator();
            while (iter.hasNext()) {
                ConfigParameter config = (ConfigParameter)iter.next();
                JComponent c = this.makeComponentFor(config);
                vBox.add(c);
            }
        } else {
            JLabel l = new JLabel("This proposal has no variants.");
            l.setEnabled(false);
            this.componentHolder.add(l);
            hBox = Box.createHorizontalBox();
            hBox.add(l);
            hBox.add(Box.createHorizontalGlue());
            vBox.add(hBox);
        }
        hBox = Box.createHorizontalBox();
        hBox.add(new JLabel("<html><hr>Base Cost: </html>"));
        hBox.add(Box.createHorizontalGlue());
        hBox.add(new JLabel("" + (int)this.proposal.getAttribute("baseEconCost", 0.0f)));
        hBox.add(new JLabel(GameSupport.getImage("money-icon.png")));
        hBox.add(Box.createHorizontalStrut(20));
        hBox.add(new JLabel("" + (int)this.proposal.getAttribute("baseSocialCost", 0.0f)));
        hBox.add(new JLabel(GameSupport.getImage("work-icon.png")));
        vBox.add(hBox);
        hBox = Box.createHorizontalBox();
        hBox.add(new JLabel("Total Cost:"));
        hBox.add(Box.createHorizontalGlue());
        this.proposalEconCost = new JLabel();
        this.proposalSocialCost = new JLabel();
        hBox.add(this.proposalEconCost);
        hBox.add(new JLabel(GameSupport.getImage("money-icon.png")));
        hBox.add(Box.createHorizontalStrut(20));
        hBox.add(this.proposalSocialCost);
        hBox.add(new JLabel(GameSupport.getImage("work-icon.png")));
        vBox.add(hBox);
        vBox.add(Box.createVerticalStrut(20));
        hBox = Box.createHorizontalBox();
        vBox.add(hBox);
        hBox.add(Box.createHorizontalGlue());
        this.okButton = new JButton("OK");
        this.okButton.setVisible(false);
        hBox.add(this.okButton);
        hBox.add(Box.createHorizontalStrut(10));
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setVisible(false);
        hBox.add(this.cancelButton);
        hBox.add(Box.createHorizontalGlue());
        this.add(vBox);
        this.built = true;
        this.update();
        this.revalidate();
        this.repaint();
    }

    public static void main(String[] args) {
        String file = "contrib/dlug/proposals/Retrofit.xml";
        ProposalView me = new ProposalView(new Main());
        JFrame f = new JFrame("Proposal Normal View");
        Proposal p = (Proposal)SimObject.readFromXML(file);
        f.getContentPane().add(me);
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
        f.setLocation(30, 30);
        me.setProposal(p);
        f.pack();
        me = new ProposalView(new Main());
        f = new JFrame("Proposal Edit View");
        p = (Proposal)SimObject.readFromXML(file);
        f.getContentPane().add(me);
        f.setDefaultCloseOperation(3);
        f.setLocation(450, 30);
        f.setVisible(true);
        me.setProposal(p);
        me.makeEditView();
        f.pack();
    }
}

