/*
 * Decompiled with CFR 0.152.
 */
package dd.ui;

import dd.hurricane.proposals.turn1.Retrofit;
import dd.sim.Proposal;
import dd.ui.MapView;
import dd.ui.RetrofitVisualizer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class ProposalVisualizer {
    public static HashMap icons = new HashMap();
    protected Proposal proposal;
    protected boolean visible;
    protected HashSet showViz;

    public ProposalVisualizer(Proposal proposal) {
        this.proposal = proposal;
        this.visible = false;
    }

    public ProposalVisualizer(Proposal proposal, HashSet showViz) {
        this.proposal = proposal;
        this.showViz = showViz;
    }

    public void setVisible(boolean visible) {
        if (this.showViz == null) {
            this.visible = visible;
        } else if (visible) {
            this.showViz.add(this.proposal.getProposalID());
        } else {
            this.showViz.remove(this.proposal.getProposalID());
        }
    }

    public boolean getVisible() {
        if (this.showViz == null) {
            return this.visible;
        }
        return this.showViz.contains(this.proposal.getProposalID());
    }

    public String getName() {
        return (String)this.proposal.getObjectAttribute("tocName");
    }

    public void show(MapView mapView) {
        Iterator iter = this.proposal.getMapIcons().iterator();
        if (!this.getVisible()) {
            return;
        }
        while (iter.hasNext()) {
            mapView.drawOverlay((String)iter.next());
        }
        iter = this.proposal.getLegendIcons().iterator();
        while (iter.hasNext()) {
            mapView.drawLegend((String)iter.next());
        }
    }

    public static ProposalVisualizer visualize(Proposal p, HashSet set) {
        if (p instanceof Retrofit) {
            return new RetrofitVisualizer(p, set);
        }
        return new ProposalVisualizer(p, set);
    }

    public static ProposalVisualizer visualize(Proposal p) {
        if (p instanceof Retrofit) {
            return new RetrofitVisualizer(p);
        }
        return new ProposalVisualizer(p);
    }
}

