/*
 * Decompiled with CFR 0.152.
 */
package dd.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.Timer;

public class PulsingButton
extends JButton {
    public static final int DELAY = 50;
    public static Color[] colors;
    public static final int NUM_COLORS = 25;
    private int colorIndex;
    private Timer timer;

    public PulsingButton(String text) {
        super(text);
        if (colors == null) {
            colors = new Color[25];
            for (int i = 0; i < 25; ++i) {
                PulsingButton.colors[i] = new Color(255, 0, 0, (int)(((double)i + 0.0) / 25.0 * 255.0));
            }
        }
        ActionListener throbber = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PulsingButton.this.colorIndex = (PulsingButton.this.colorIndex + 1) % 25;
                PulsingButton.this.repaint();
            }
        };
        this.timer = new Timer(50, throbber);
    }

    public synchronized void startAnimation() {
        this.timer.start();
    }

    public synchronized void stopAnimation() {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        this.colorIndex = 0;
        this.repaint();
    }

    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(colors[this.colorIndex]);
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("Pulsing Button");
        JPanel p = new JPanel();
        final PulsingButton me = new PulsingButton("Choose or perish");
        JCheckBox animate = new JCheckBox("Animate Pulsing");
        f.setDefaultCloseOperation(3);
        p.add(animate);
        p.add(me);
        animate.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    me.startAnimation();
                } else {
                    me.stopAnimation();
                }
            }
        });
        f.getContentPane().add(p);
        f.pack();
        f.setVisible(true);
    }
}

