/*
 * Decompiled with CFR 0.152.
 */
package dd.ui;

import dd.hurricane.Scenario;
import dd.net.TurnClient;
import dd.net.TurnServer;
import dd.sim.Briefing;
import dd.sim.GameRoot;
import dd.sim.Map;
import dd.sim.Player;
import dd.sim.Proposal;
import dd.util.DLUGUI;

public class Robot
implements DLUGUI {
    protected TurnClient tc;
    protected int turnNumber;
    protected Map log = new Map(10, 10);
    private boolean running;
    private TurnServer turnServer;

    public Robot() {
        this.log.debug("Created Robot");
        this.serverStartup();
        this.tc.setUI(this);
    }

    public void serverStartup() {
        String serverName = null;
        this.tc = null;
        if (serverName == null) {
            serverName = "127.0.0.1";
        }
        try {
            this.tc = new TurnClient(this, serverName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public Robot run(String gameName) {
        this.log.debug("Robot run begin");
        this.running = true;
        this.tc.waitUntilReady();
        if (gameName != null) {
            this.tc.joinGame(gameName);
        }
        this.tc.joinGame("Robot", 1);
        this.log.debug("Robot run end");
        return this;
    }

    public void availableGames(String[] gameList) {
        this.log.warning("Robots shold never have to choose among a list of games");
    }

    public void joinedGame() {
        this.log.debug("Robot joinedGame");
    }

    public void enableUI() {
        this.log.debug("Robot enableUI");
    }

    public void disableUI() {
        this.log.debug("Robot disableUI");
    }

    public void pauseUI(String message) {
        this.log.debug("Robot pauseUI: " + message);
    }

    public void unpauseUI() {
        this.log.debug("Robot unpauseUI");
    }

    public void startBriefing(Briefing b) {
        this.log.debug("Robot startBriefing");
        this.briefingEnded();
    }

    public void briefingEnded() {
        this.log.debug("Robot briefingEnded");
        this.tc.endBriefing();
    }

    public void lostServer() {
        this.log.debug("Robot lost connection to server.");
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void addPlayer(Player player) {
        this.log.debug("Robot addPlayer" + player);
    }

    public void setNumber(String turnNumber) {
        this.log.debug("Robot setPlayer " + turnNumber);
        this.turnNumber = Integer.parseInt(turnNumber);
    }

    public void beginSetupPhase() {
        this.log.debug("Robot beginSetupPhase");
    }

    public void setRoot(GameRoot r) {
        this.log.debug("Robot setRoot");
    }

    public void newScenario(Scenario s) {
        this.log.debug("Robot newScenario");
    }

    public void beginNegotiationPhase() {
        this.log.debug("Robot beginNegotiationPhase");
    }

    private void expressOpinions() {
        this.log.debug("Robot expressOpinions");
    }

    public void callForVote(Player caller, String family) {
        this.log.debug("Robot callForVote:" + family);
    }

    public void secondNotify(Player p, boolean support) {
    }

    public void doneNotify(Player p) {
    }

    public void rankFamily(String familyName) {
        this.log.debug("Robot rankFamily: " + familyName);
    }

    public void prepareForVotingOn(Proposal proposal) {
        this.log.debug("Robot prepareForVotingOn: " + proposal.getFamily());
    }

    public void startVote() {
        this.log.debug("Robot startVote");
    }

    public void startVotingTimer() {
        this.log.debug("Robot startVotingTimer");
        this.tc.votingTimerExpired();
    }

    public void gameMessage(String message) {
    }

    public void notifyUser(String message) {
    }

    public void errorMessage(String message) {
        this.log.debug("Robot errorMessage: " + message);
    }

    public void endVote() {
        this.log.debug("Robot endVote");
    }

    public void gameEnded() {
    }
}

