/*
 * Decompiled with CFR 0.152.
 */
package dd.ui;

import dd.hurricane.Main;
import dd.hurricane.Scenario;
import dd.net.TurnClient;
import dd.net.TurnServer;
import dd.sim.Briefing;
import dd.sim.GameRoot;
import dd.sim.Layer;
import dd.sim.Map;
import dd.ui.Robot;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class Simulator
extends Robot {
    private GameRoot root;
    private TurnServer server;
    private int seed;

    public void serverStartup() {
        try {
            this.server = TurnServer.startServer(true);
            this.tc = new TurnClient(this, "127.0.0.1");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public void run(int s) {
        this.seed = s;
        this.server.setRNGSeed(this.seed + 12345678);
        this.run(null);
    }

    public void beginNegotiationPhase() {
        this.log.debug("Simulator beginNegotiationPhase");
        this.tc.randomProposal();
    }

    public void setRoot(GameRoot r) {
        this.log.debug("Simulator setRoot");
        this.root = r;
    }

    public void startBriefing(Briefing b) {
        float turn = b.getAttribute("turn", 0.0f);
        if (turn > 0.0f) {
            try {
                FileWriter out = new FileWriter("sim/metrics/" + turn + "/" + this.seed);
                String[] metrics = Main.metrics;
                for (int i = 0; i < metrics.length; ++i) {
                    out.write("\t" + b.getAttribute(metrics[i], 0.0f));
                }
                out.write("\n");
                out.close();
                out = new FileWriter("sim/budget/" + turn + "/" + this.seed);
                Scenario s = b.getGameRoot().getScenario();
                int decon = (int)s.getAttribute("defaultEconBudget", 0.0f);
                int dsocial = (int)s.getAttribute("defaultSocialBudget", 0.0f);
                int econ = (int)s.getCurrentEconBudget();
                int soc = (int)s.getCurrentSocialBudget();
                out.write("" + decon + "\t" + dsocial + "\t" + econ + "\t" + soc + "\n");
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (turn > 2.0f) {
            b.writeXML("sim/debriefing/" + this.seed);
        }
        this.tc.endBriefing();
    }

    public void gameEnded() {
        try {
            int i;
            Map map = this.root.getScenario().getMap();
            FileWriter out = new FileWriter("sim/props/" + this.seed);
            ArrayList plist = (ArrayList)map.getLayer("proposals").getObjectAttribute("passedProposals");
            for (int i2 = 0; i2 < plist.size(); ++i2) {
                out.write((String)plist.get(i2) + "\n");
            }
            out.close();
            FileWriter out2 = new FileWriter("sim/issues/" + this.seed);
            Layer probLayer = map.getLayer("problems");
            ArrayList issues = (ArrayList)probLayer.getObjectAttribute("issues");
            out2.write(this.summary(issues));
            for (int i3 = 0; i3 < issues.size(); ++i3) {
                String problem = (String)issues.get(i3);
                out2.write(problem + "\t" + probLayer.getAttribute(problem, -99.0f) + "\n");
            }
            out2.close();
            FileWriter out3 = new FileWriter("sim/lu/" + this.seed);
            Layer lu = map.getLayer("landusePreTrigger");
            String[] luNames = Main.luNames;
            for (i = 0; i < luNames.length; ++i) {
                out3.write("" + map.luCount(luNames[i], lu) + "\t");
            }
            for (i = 0; i < luNames.length; ++i) {
                out3.write("" + map.getAttribute("ratio" + luNames[i]) + "\t");
            }
            out3.write("" + map.getAttribute("imbalance"));
            out3.write("\t" + map.getObjectAttribute("maxmin"));
            out3.write("\n");
            out3.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.exit(0);
    }

    public String summary(ArrayList issues) {
        String result = "";
        for (int i = 0; i < issues.size(); ++i) {
            String p = (String)issues.get(i);
            if ("floodingDowntown".equals(p)) {
                result = result + "a";
            }
            if ("septicWaterTable".equals(p)) {
                result = result + "b";
            }
            if ("blackSwanVirus".equals(p)) {
                result = result + "c";
            }
            if ("beachLoss".equals(p)) {
                result = result + "d";
            }
            if ("industrialRunoff".equals(p)) {
                result = result + "e";
            }
            if ("weakJobMarket".equals(p)) {
                result = result + "f";
            }
            if ("overcommercialization".equals(p)) {
                result = result + "g";
            }
            if ("soaringLandValues".equals(p)) {
                result = result + "h";
            }
            if (!"casino".equals(p)) continue;
            result = result + "i";
        }
        return result + "\n";
    }

    public static void main(String[] args) {
        int s = args.length > 0 ? Integer.parseInt(args[0]) : 4978139;
        new Simulator().run(s);
        try {
            while (true) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
    }
}

