/*
 * Decompiled with CFR 0.152.
 */
package dd.ui;

import dd.hurricane.Main;
import dd.hurricane.Scenario;
import dd.sim.Player;
import dd.ui.GUIEvents;
import dd.ui.GameSupport;
import dd.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class StatusBar
extends JPanel
implements PropertyChangeListener {
    private GUIEvents dlug;
    private JLabel[] role;
    private JLabel[] player;
    private JLabel[] favors;
    private JLabel eBudget;
    private JLabel sBudget;

    public StatusBar(GUIEvents dlug) {
        super(new BorderLayout());
        int i;
        this.dlug = dlug;
        this.role = new JLabel[4];
        this.player = new JLabel[4];
        this.favors = new JLabel[4];
        this.eBudget = new JLabel();
        this.sBudget = new JLabel();
        this.setBorder(BorderFactory.createEtchedBorder());
        Box contents = Box.createHorizontalBox();
        this.add(contents);
        Box playerBox = Box.createVerticalBox();
        contents.add(playerBox);
        playerBox.add(new JLabel("Player"));
        for (i = 0; i < 4; ++i) {
            this.player[i] = new JLabel();
            playerBox.add(this.player[i]);
        }
        contents.add(new JLabel("  "));
        contents.add(Box.createHorizontalGlue());
        Box roleBox = Box.createVerticalBox();
        contents.add(roleBox);
        roleBox.add(new JLabel("Role"));
        for (i = 0; i < 4; ++i) {
            this.role[i] = new JLabel();
            roleBox.add(this.role[i]);
        }
        contents.add(Box.createHorizontalGlue());
        contents.add(new JLabel("  "));
        Box favorBox = Box.createVerticalBox();
        contents.add(favorBox);
        favorBox.add(new JLabel("Favors"));
        for (i = 0; i < 4; ++i) {
            this.favors[i] = new JLabel();
            favorBox.add(this.favors[i]);
        }
        contents.add(Box.createHorizontalGlue());
        Box budgetBox = Box.createHorizontalBox();
        contents.add(budgetBox);
        budgetBox.setBorder(BorderFactory.createTitledBorder("Budget"));
        Box vBox = Box.createVerticalBox();
        budgetBox.add(vBox);
        Box hBox = Box.createHorizontalBox();
        vBox.add(hBox);
        hBox.add(this.eBudget);
        hBox.add(new JLabel(GameSupport.getImage("money-icon.png")));
        hBox.add(Box.createHorizontalStrut(20));
        hBox.add(this.sBudget);
        hBox.add(new JLabel(GameSupport.getImage("work-icon.png")));
        hBox = Box.createHorizontalBox();
        vBox.add(hBox);
        hBox.add(new JLabel("Money/Work"));
    }

    public void rootChanged() {
        this.dlug.getRoot().getPlayers().addPropertyChangeListener(this);
        this.repopulate();
    }

    public void propertyChange(PropertyChangeEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StatusBar.this.repopulate();
            }
        });
    }

    public void repopulate() {
        for (int i = 0; i < 4; ++i) {
            Player p = this.dlug.getPlayer(i + 1);
            Color c = this.dlug.getColor(p);
            String r = p.getRole();
            if (r == null) {
                r = "--";
            }
            this.role[i].setText(StringUtils.capitalize(r));
            this.role[i].setForeground(c);
            this.player[i].setText(p.getName());
            this.player[i].setForeground(c);
            this.favors[i].setText("" + p.getFavors());
            this.favors[i].setForeground(c);
        }
        Scenario s = this.dlug.getRoot().getScenario();
        this.eBudget.setText(Integer.toString((int)s.getCurrentEconBudget()));
        this.sBudget.setText(Integer.toString((int)s.getCurrentSocialBudget()));
        this.validate();
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("Score");
        f.getContentPane().add(new StatusBar(new Main()));
        f.pack();
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }
}

