/*
 * Decompiled with CFR 0.152.
 */
package dd.ui;

import dd.sim.Layer;
import dd.sim.Map;
import dd.sim.MapCell;
import dd.ui.AttributeEditor;
import dd.ui.HexView;
import dd.ui.MapSelectionListener;
import dd.ui.MapView;
import dd.util.Logger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TestController
implements MapSelectionListener {
    private MapView mv;
    private Map m;
    private DefaultComboBoxModel layerListModel;
    private AttributeEditor ae;
    private MapCell currentCell;
    private JFrame mainFrame;
    protected JMenuItem miOpen;
    protected JMenuItem miClose;
    protected JMenuItem miPrint;
    protected JMenuItem miQuit;
    protected JMenuItem miUndo;
    protected JMenuItem miCut;
    protected JMenuItem miCopy;
    protected JMenuItem miPaste;
    static /* synthetic */ Class class$dd$hurricane$HurricaneHex;

    public void mapSelectionUpdated(MapView mapView) {
        this.currentCell = ((HexView)mapView.getSelectedCells().iterator().next()).getCell();
        this.layerListModel.removeAllElements();
        Iterator iter = this.currentCell.getLayers().iterator();
        while (iter.hasNext()) {
            this.layerListModel.addElement(((Layer)iter.next()).getName());
        }
    }

    public void mapSelectionDone(MapView mapView) {
    }

    public JMenuBar makeMenu() {
        MenuHandler menuHandler = new MenuHandler();
        int theMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        this.miOpen = new JMenuItem("Open...");
        this.miOpen.setAccelerator(KeyStroke.getKeyStroke(79, theMask));
        this.miOpen.addActionListener(menuHandler);
        fileMenu.add(this.miOpen).setEnabled(true);
        this.miClose = new JMenuItem("Close");
        this.miClose.setAccelerator(KeyStroke.getKeyStroke(87, theMask));
        this.miClose.addActionListener(menuHandler);
        fileMenu.add(this.miClose).setEnabled(true);
        this.miPrint = new JMenuItem("Print");
        this.miPrint.setAccelerator(KeyStroke.getKeyStroke(80, theMask));
        this.miPrint.addActionListener(menuHandler);
        fileMenu.add(this.miPrint).setEnabled(true);
        this.miQuit = new JMenuItem("Quit");
        this.miQuit.setAccelerator(KeyStroke.getKeyStroke(81, theMask));
        this.miQuit.addActionListener(menuHandler);
        fileMenu.add(this.miQuit).setEnabled(true);
        menuBar.add(fileMenu);
        JMenu editMenu = new JMenu("Edit");
        this.miUndo = new JMenuItem("Undo");
        this.miUndo.setAccelerator(KeyStroke.getKeyStroke(90, theMask));
        this.miUndo.addActionListener(menuHandler);
        editMenu.add(this.miUndo).setEnabled(true);
        this.miCut = new JMenuItem("Cut");
        this.miCut.setAccelerator(KeyStroke.getKeyStroke(88, theMask));
        this.miCut.addActionListener(menuHandler);
        editMenu.add(this.miCut).setEnabled(true);
        this.miCopy = new JMenuItem("Copy");
        this.miCopy.setAccelerator(KeyStroke.getKeyStroke(67, theMask));
        this.miCopy.addActionListener(menuHandler);
        editMenu.add(this.miCopy).setEnabled(true);
        this.miPaste = new JMenuItem("Paste");
        this.miPaste.setAccelerator(KeyStroke.getKeyStroke(86, theMask));
        this.miPaste.addActionListener(menuHandler);
        editMenu.add(this.miPaste).setEnabled(true);
        menuBar.add(editMenu);
        return menuBar;
    }

    public void initMap(Map m) {
        Layer l = m.createLayer("distance");
        Layer l2 = m.createLayer("pie");
        Layer l3 = m.createLayer("Land Value");
        l2.setAttribute("float one", 1.0f);
        l2.setAttribute("string one", "fred");
        m.createLayer("Piece value");
        m.createLayer("Home value");
        m.createLayer("School value");
        for (int i = 0; i < m.getMapHeight(); ++i) {
            for (int j = 0; j < m.getMapWidth(); ++j) {
                m.cellAt(i, j).setAttribute("sven", "fun");
                m.cellAt(i, j).setAttribute("funner", 2.2f);
                m.cellAt(i, j).setAttribute("pieObj", l2, 2.2f);
                m.cellAt(i, j).setAttribute("pieVar", l2, 9.8f);
                m.cellAt(i, j).setAttribute("distVar", l, -2.2f);
                m.cellAt(i, j).setAttribute("rand", l3, (float)Math.random());
                m.setAttribute("distance", m.cellAt(i, j), "dist", (float)(Math.random() * 10.0));
            }
        }
    }

    public void makeUI() {
        this.makeUI(null);
    }

    public void makeUI(String mapFile) {
        JFrame f = new JFrame("Disaster Game");
        f.getContentPane().setLayout(new BorderLayout());
        this.mainFrame = f;
        if (mapFile == null) {
            this.m = new Map(20, 20);
            this.initMap(this.m);
        } else {
            this.m = (Map)Map.readFromXML(mapFile);
        }
        this.mv = new MapView(this.m, class$dd$hurricane$HurricaneHex == null ? (class$dd$hurricane$HurricaneHex = TestController.class$("dd.hurricane.HurricaneHex")) : class$dd$hurricane$HurricaneHex);
        this.mv.beginSingleSelection(this, null);
        JSlider distSlider = new JSlider(0, 20, 2);
        distSlider.setSnapToTicks(true);
        distSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int val = ((JSlider)e.getSource()).getValue();
                Iterator i = TestController.this.m.getCells().iterator();
                MapCell t = TestController.this.m.cellAt(10, 10);
                while (i.hasNext()) {
                    MapCell c = (MapCell)i.next();
                    if (c.cDistanceTo(t) <= (double)val) {
                        c.setAttribute("dist", "yes");
                        continue;
                    }
                    c.setAttribute("dist", "no");
                }
            }
        });
        this.ae = new AttributeEditor(new HashMap());
        Box box = Box.createVerticalBox();
        Box mapBox = Box.createVerticalBox();
        JComboBox<String> layerList = new JComboBox<String>(new String[]{"Layers"});
        this.layerListModel = (DefaultComboBoxModel)layerList.getModel();
        layerList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox cb = (JComboBox)e.getSource();
                String layerName = (String)cb.getSelectedItem();
                if (TestController.this.currentCell != null) {
                    Layer l = TestController.this.m.getLayer(layerName);
                    TestController.this.ae.setAttributes(TestController.this.currentCell.getLayerAttributes(l));
                }
            }
        });
        box.add(layerList);
        box.add(this.ae.makeUI());
        mapBox.add(this.mv);
        mapBox.add(distSlider);
        f.getContentPane().add((Component)box, "East");
        f.getContentPane().add((Component)mapBox, "Center");
        f.setJMenuBar(this.makeMenu());
        f.pack();
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }

    public static void main(String[] args) {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        TestController me = new TestController();
        if (args.length == 1) {
            me.makeUI(args[0]);
        } else {
            me.makeUI();
        }
    }

    static /* synthetic */ JFrame access$000(TestController x0) {
        return x0.mainFrame;
    }

    static /* synthetic */ Map access$102(TestController x0, Map x1) {
        x0.m = x1;
        return x0.m;
    }

    static /* synthetic */ MapView access$200(TestController x0) {
        return x0.mv;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ColorHex
    extends HexView {
        public void setCell(MapCell c) {
            super.setCell(c);
            String color = (String)this.myCell.getObjectAttribute("color", this.myCell.getMap().createLayer("color"));
            if (color != null) {
                int r = Integer.parseInt(color.substring(1, 3), 16);
                int g = Integer.parseInt(color.substring(3, 5), 16);
                int b = Integer.parseInt(color.substring(5, 7), 16);
                this.setMyColor(new Color(r, g, b));
            }
        }
    }

    class MenuHandler
    implements ActionListener {
        MenuHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void actionPerformed(ActionEvent e) {
            block17: {
                if (e.getActionCommand().equals(TestController.this.miQuit.getActionCommand())) {
                    System.exit(0);
                }
                if (e.getActionCommand().equals(TestController.this.miOpen.getActionCommand()) && (returnVal = (fc = new JFileChooser()).showOpenDialog(TestController.access$000(TestController.this))) == 0) {
                    r = null;
                    try {
                        r = new FileReader(fc.getSelectedFile());
                        TestController.access$102(TestController.this, (Map)Map.readFromXML(r));
                        TestController.access$200(TestController.this).setMap(TestController.access$100(TestController.this));
                        var7_6 = null;
                        ** if (r == null) goto lbl-1000
                    }
                    catch (Throwable var6_14) {
                        var7_8 = null;
                        if (r != null) {
                            try {
                                r.close();
                            }
                            catch (IOException ignored) {
                                // empty catch block
                            }
                        }
                        throw var6_14;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            r.close();
                        }
                        catch (IOException ignored) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block17;
                        catch (IOException ioException) {
                            Logger.getDefaultLog().error("Error reading map.");
                            var7_7 = null;
                            if (r != null) {
                                try {
                                    r.close();
                                }
                                catch (IOException ignored) {}
                            }
                        }
                    }
                }
            }
            if (e.getActionCommand().equals(TestController.this.miPrint.getActionCommand())) {
                job = PrinterJob.getPrinterJob();
                format = job.pageDialog(job.defaultPage());
                p = new Printable(this){
                    private final /* synthetic */ MenuHandler this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public int print(Graphics g, PageFormat format, int pageNum) {
                        if (pageNum != 0) {
                            return 1;
                        }
                        return 0;
                    }
                };
                job.setPrintable(p, format);
                try {
                    if (job.printDialog()) {
                        job.print();
                    }
                }
                catch (PrinterException ex) {
                    // empty catch block
                }
            }
        }
    }
}

