/*
 * Decompiled with CFR 0.152.
 */
package dd.ui;

import dd.sim.Player;
import dd.sim.Proposal;
import dd.ui.BallotPanel;
import dd.ui.CallPanel;
import dd.ui.GUIEvents;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class VotePanel
extends JPanel {
    private GUIEvents dlug;
    BallotPanel ballotPanel;
    CallPanel callPanel;
    JPanel statusPanel;
    JLabel instructions;
    JLabel[] playerNames;
    JLabel[] playerDone;
    JPanel responsePanel;
    JPanel center;

    public VotePanel(GUIEvents dlugui) {
        super(new BorderLayout());
        this.dlug = dlugui;
        this.callPanel = new CallPanel(this.dlug);
        this.ballotPanel = new BallotPanel(this.dlug);
        this.responsePanel = new JPanel(false);
        this.playerNames = new JLabel[4];
        this.playerDone = new JLabel[4];
        Box lt = Box.createVerticalBox();
        Box rt = Box.createVerticalBox();
        for (int i = 0; i < 4; ++i) {
            this.playerNames[i] = new JLabel();
            this.playerDone[i] = new JLabel();
            lt.add(this.playerNames[i]);
            rt.add(this.playerDone[i]);
        }
        Box box = Box.createHorizontalBox();
        box.add(lt);
        box.add(Box.createHorizontalStrut(50));
        box.add(rt);
        this.responsePanel.add(box);
        this.statusPanel = new JPanel(new BorderLayout(), false);
        this.instructions = new JLabel();
        this.statusPanel.add((Component)this.instructions, "Center");
        this.phase("Negotiate");
        this.add((Component)this.statusPanel, "North");
        this.revalidate();
    }

    public void rootChanged() {
        for (int i = 0; i < 4; ++i) {
            Player p = this.dlug.getPlayer(i + 1);
            this.playerNames[i].setText(p.getName());
            this.playerNames[i].setForeground(this.dlug.getColor(p));
        }
        this.updateResponse();
    }

    public void phase(String phase) {
        this.statusPanel.setBorder(BorderFactory.createTitledBorder("Status: " + phase));
        this.updateResponse();
    }

    public void doneNotify(Player p) {
        this.updateResponse();
    }

    public void updateResponse() {
        for (int i = 0; i < 4; ++i) {
            this.playerDone[i].setText(this.dlug.getRoot().getPlayerStatus("p" + (i + 1)));
        }
    }

    public void clear() {
        if (this.center != null) {
            this.remove(this.center);
        }
        this.revalidate();
    }

    public void swap(JPanel p) {
        this.clear();
        this.center = p;
        this.add((Component)this.center, "Center");
        this.revalidate();
    }

    public void prepareForVotingOn(Proposal p) {
        this.statusPanel.add((Component)this.responsePanel, "South");
        this.ballotPanel.prepareForVotingOn(p);
        this.phase("Voting");
        this.instructions.setText("<html>Voting ends when all timers expire.<br>Click \"Done\" to expire your timer early.<br>All timers reset when a vote is cast.");
        this.swap(this.ballotPanel);
    }

    public void startVotingTimer() {
        this.updateResponse();
        this.ballotPanel.startVotingTimer();
    }

    public void listChanged(Iterator i) {
        this.callPanel = new CallPanel(this.dlug);
        this.statusPanel.remove(this.responsePanel);
        if (i.hasNext()) {
            this.instructions.setText("<html>Click on one of the proposals in the list<br>below to call for a vote on it.");
        } else {
            this.instructions.setText("<html>No proposals have been configured for voting. <br><br>To make a proposal, switch to the \"Proposals\" tab, <br>select a proposal, and click the \"Propose\" button.");
        }
        this.callPanel.listChanged(i);
        this.phase("Negotiating");
        this.swap(this.callPanel);
    }

    public void caller() {
        this.clear();
        this.instructions.setText("Waiting for vote to begin...");
    }
}

