/*
 * Decompiled with CFR 0.152.
 */
package dd.ui;

import dd.hurricane.Main;
import dd.sim.Player;
import dd.ui.GUIEvents;
import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class VotesLeftPanel
extends JPanel
implements PropertyChangeListener {
    private JLabel[] playerNames;
    private JLabel[] playerVotes;
    private JLabel[] playerBonus;
    private GUIEvents ui;

    public VotesLeftPanel(GUIEvents dlug) {
        super(new BorderLayout());
        int i;
        this.ui = dlug;
        this.ui.getRoot().getPlayers().addPropertyChangeListener(this);
        this.setBorder(BorderFactory.createTitledBorder("Votes Left"));
        this.playerNames = new JLabel[4];
        this.playerVotes = new JLabel[4];
        this.playerBonus = new JLabel[4];
        Box hBox = Box.createHorizontalBox();
        Box vBox = Box.createVerticalBox();
        vBox.add(new JLabel("Player"));
        for (i = 0; i < 4; ++i) {
            this.playerNames[i] = new JLabel();
            vBox.add(this.playerNames[i]);
        }
        hBox.add(vBox);
        hBox.add(Box.createHorizontalGlue());
        vBox = Box.createVerticalBox();
        vBox.add(new JLabel("Favors"));
        for (i = 0; i < 4; ++i) {
            this.playerVotes[i] = new JLabel();
            vBox.add(this.playerVotes[i]);
        }
        hBox.add(vBox);
        hBox.add(Box.createHorizontalGlue());
        vBox = Box.createVerticalBox();
        vBox.add(new JLabel("Votes"));
        for (i = 0; i < 4; ++i) {
            this.playerBonus[i] = new JLabel();
            vBox.add(this.playerBonus[i]);
        }
        hBox.add(vBox);
        this.add(hBox);
        this.repopulate();
    }

    public void rootChanged() {
        this.ui.getRoot().getPlayers().addPropertyChangeListener(this);
        this.repopulate();
    }

    public void propertyChange(PropertyChangeEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VotesLeftPanel.this.repopulate();
            }
        });
    }

    public void repopulate() {
        for (int i = 0; i < 4; ++i) {
            Player p = this.ui.getPlayer(i + 1);
            this.playerNames[i].setText(p.getName());
            this.playerNames[i].setForeground(this.ui.getColor(p));
            this.playerVotes[i].setText(Integer.toString(p.getFavors()));
            this.playerVotes[i].setForeground(this.ui.getColor(p));
            this.playerBonus[i].setText(Integer.toString(p.getVotes()));
            this.playerBonus[i].setForeground(this.ui.getColor(p));
        }
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("Votes Left");
        f.getContentPane().add(new VotesLeftPanel(new Main()));
        f.pack();
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }
}

