/*
 * Decompiled with CFR 0.152.
 */
package dd.util;

import dd.sim.Layer;
import dd.sim.Map;
import dd.sim.SimObject;
import dd.util.Registry;
import dd.util.SimXMLReader;
import dd.util.SimXMLWriter;
import dd.util.XMLHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AttributeHelper {
    public static Node writeAttributes(Document document, HashMap map) {
        return AttributeHelper.writeAttributes(document, map, "attributes");
    }

    public static Node writeAttributes(Document document, HashMap map, String objName) {
        return AttributeHelper.writeAttributes(document, map, objName, "attribute");
    }

    public static Node writeAttributes(Document document, HashMap map, String objName, String tagName) {
        return AttributeHelper.writeAttributes(document, map, objName, tagName, "name", "value");
    }

    public static Node writeAttributes(Document document, HashMap map, String objName, String tagName, String keyName, String valName) {
        Element newNode = XMLHelper.createNode(document, objName);
        if (!map.isEmpty()) {
            Iterator keys = map.keySet().iterator();
            while (keys.hasNext()) {
                Element attrNode;
                SimXMLWriter w;
                Object key = keys.next();
                Object value = map.get(key);
                if (key instanceof Layer) {
                    Element childLayer = (Element)AttributeHelper.writeAttributes(document, (HashMap)value, "layer");
                    childLayer.setAttribute("name", ((Layer)key).getName());
                    newNode.appendChild(childLayer);
                    continue;
                }
                if (value instanceof HashMap) {
                    Node inner = AttributeHelper.writeAttributes(document, (HashMap)value, key.toString());
                    if (value instanceof Registry) {
                        ((Element)inner).setAttribute("type", "Registry");
                    }
                    newNode.appendChild(inner);
                    continue;
                }
                if (value instanceof List) {
                    Iterator iter = ((List)value).iterator();
                    Element listNode = XMLHelper.createNode(document, tagName, keyName, key.toString(), newNode);
                    listNode.setAttribute("type", "list");
                    while (iter.hasNext()) {
                        Object listObj = iter.next();
                        if (listObj instanceof SimObject) {
                            Element a = XMLHelper.createNode(document, "item");
                            w = new SimXMLWriter((SimObject)listObj);
                            w.setDocument(document);
                            a.appendChild(w.getXMLNode());
                            listNode.appendChild(a);
                            continue;
                        }
                        XMLHelper.createTextNode(document, "item", listObj.toString(), listNode);
                    }
                    continue;
                }
                if (value instanceof SimObject) {
                    attrNode = XMLHelper.createNode(document, tagName, keyName, key.toString(), newNode);
                    w = new SimXMLWriter((SimObject)value);
                    w.setDocument(document);
                    attrNode.appendChild(w.getXMLNode());
                    continue;
                }
                if (value instanceof Integer) {
                    attrNode = XMLHelper.createNode(document, tagName, keyName, key.toString(), newNode);
                    attrNode.setAttribute(valName, value.toString());
                    attrNode.setAttribute("type", "integer");
                    continue;
                }
                if (value instanceof String && ((String)value).length() > 0 && Character.isDigit(((String)value).charAt(0))) {
                    attrNode = XMLHelper.createNode(document, tagName, keyName, key.toString(), newNode);
                    attrNode.setAttribute(valName, value.toString());
                    attrNode.setAttribute("type", "string");
                    continue;
                }
                if (value instanceof String && ((String)value).length() > 100) {
                    attrNode = XMLHelper.createTextNode(document, tagName, value.toString(), newNode);
                    attrNode.setAttribute(keyName, key.toString());
                    continue;
                }
                attrNode = XMLHelper.createNode(document, tagName, keyName, key.toString(), newNode);
                attrNode.setAttribute(valName, value.toString());
            }
        }
        return newNode;
    }

    public static HashMap readAttributes(Node node, Map world) {
        return AttributeHelper.readAttributes(node, world, "attribute", "name", "value");
    }

    public static HashMap readAttributes(Node node, Map world, String tagName, String keyField, String valueField) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node current = children.item(i);
            if (current.getNodeName().equals(tagName)) {
                String typeValue;
                Element e;
                String attributeName = XMLHelper.getNodeAttribute(current, keyField);
                String attributeValue = XMLHelper.getNodeAttribute(current, valueField);
                if (attributeValue == null && (e = XMLHelper.findFirstElement(current)) == null) {
                    attributeValue = XMLHelper.nodeText(current);
                }
                if ("list".equals(typeValue = XMLHelper.getNodeAttribute(current, "type"))) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    for (Node n = current.getFirstChild(); n != null; n = n.getNextSibling()) {
                        if (!"item".equals(n.getNodeName())) continue;
                        Element e2 = XMLHelper.findFirstElement(n);
                        if (e2 != null) {
                            SimObject o = SimXMLReader.read(e2);
                            list.add(o);
                            continue;
                        }
                        String s = XMLHelper.nodeText(n);
                        Integer iVal = null;
                        try {
                            iVal = new Integer(s);
                        }
                        catch (NumberFormatException ignored) {
                            // empty catch block
                        }
                        if (iVal != null) {
                            list.add(iVal);
                            continue;
                        }
                        list.add(s);
                    }
                    map.put(attributeName, list);
                    continue;
                }
                if ("integer".equals(typeValue)) {
                    Integer intValue = new Integer(attributeValue);
                    map.put(attributeName, intValue);
                    continue;
                }
                if ("string".equals(typeValue)) {
                    map.put(attributeName, attributeValue);
                    continue;
                }
                if (attributeValue == null && (e = XMLHelper.findFirstElement(current)) != null) {
                    SimObject o = SimXMLReader.read(e);
                    map.put(attributeName, o);
                    continue;
                }
                Float floatValue = null;
                try {
                    floatValue = new Float(attributeValue);
                }
                catch (NumberFormatException ignored) {
                    // empty catch block
                }
                if (floatValue != null) {
                    map.put(attributeName, floatValue);
                    continue;
                }
                map.put(attributeName, attributeValue);
                continue;
            }
            if (current.getNodeName().equals("layer")) {
                String layerName = XMLHelper.getNodeAttribute(current, keyField);
                Layer l = world.createLayer(layerName);
                map.put(l, AttributeHelper.readAttributes(current, world));
                continue;
            }
            if (current.getNodeType() != 1) continue;
            HashMap innerMap = AttributeHelper.readAttributes(current, world);
            if ("Registry".equals(XMLHelper.getNodeAttribute(current, "type"))) {
                map.put(current.getNodeName(), new Registry((java.util.Map)innerMap));
                continue;
            }
            map.put(current.getNodeName(), innerMap);
        }
        return map;
    }

    public static void main(String[] args) {
        HashMap landUses = new HashMap();
        HashMap<String, Object> landUse = new HashMap<String, Object>();
        landUse.put("useName", "Residential");
        landUse.put("proportionOfCell", new Float(0.25f));
        landUse.put("numberOfAgents", new Float(250.0f));
        landUses.put("Residential", landUse);
        landUse = new HashMap();
        landUse.put("useName", "Industrial");
        landUse.put("proportionOfCell", new Float(0.55f));
        landUse.put("numberOfAgents", new Float(50.0f));
        landUses.put("Industrial", landUse);
        landUse = new HashMap();
        ArrayList<String> l = new ArrayList<String>(4);
        l.add("one");
        l.add("two");
        l.add("three");
        landUse.put("testList", l);
        landUse.put("useName", "Commercial");
        landUse.put("proportionOfCell", new Float(0.2f));
        landUse.put("numberOfAgents", new Float(75.0f));
        landUses.put("Commercial", landUse);
        Document d = XMLHelper.makeDocument();
        Node n = AttributeHelper.writeAttributes(d, landUses, "LandUses");
        d.appendChild(n);
        XMLHelper.writeXMLFile("land-uses.xml", (Node)d);
    }
}

