/*
 * Decompiled with CFR 0.152.
 */
package dd.util;

import dd.util.TimedActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Timer;

public class CountdownTimer
implements ActionListener {
    private Timer timer;
    private ArrayList listeners;
    private int secondsToGo;
    private int totalTime;

    public CountdownTimer(int seconds) {
        this.secondsToGo = seconds;
        this.totalTime = seconds;
        this.listeners = new ArrayList();
        this.timer = new Timer(1000, this);
    }

    public int getTimeRemaining() {
        return this.secondsToGo;
    }

    public void addTimedActionListener(TimedActionListener listener) {
        this.listeners.add(listener);
    }

    public void actionPerformed(ActionEvent e) {
        Iterator iter = this.listeners.iterator();
        --this.secondsToGo;
        if (this.secondsToGo <= 0) {
            this.timer.stop();
            while (iter.hasNext()) {
                ((TimedActionListener)iter.next()).timerElapsed(this);
            }
        } else {
            while (iter.hasNext()) {
                ((TimedActionListener)iter.next()).timerTick(this);
            }
        }
    }

    public void start() {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((TimedActionListener)iter.next()).timerStarted(this);
        }
        this.timer.start();
    }

    public void stop() {
        this.timer.stop();
    }

    public void reset() {
        this.timer.restart();
        this.secondsToGo = this.totalTime;
    }
}

