/*
 * Decompiled with CFR 0.152.
 */
package dd.util;

import dd.util.Logger;
import java.io.FileReader;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;

public class DelimReader
extends Reader {
    private int charsSoFar;
    private String target;
    private int targetLength;
    private PushbackReader in;
    private char[] buf;

    public DelimReader(Reader in, String eofMarker) {
        this.target = eofMarker;
        this.charsSoFar = 0;
        this.targetLength = this.target.length();
        this.buf = new char[this.targetLength];
        this.in = new PushbackReader(in, this.targetLength);
    }

    public void close() {
    }

    public int read() throws IOException {
        if (this.charsSoFar == this.targetLength) {
            return -1;
        }
        int c = this.in.read();
        if (c == -1) {
            return -1;
        }
        if ((char)c == this.target.charAt(this.charsSoFar)) {
            this.buf[this.charsSoFar] = (char)c;
            ++this.charsSoFar;
            return this.read();
        }
        this.in.unread(c);
        if (this.charsSoFar > 0) {
            this.in.unread(this.buf, 0, this.charsSoFar);
            this.charsSoFar = 0;
        }
        return this.in.read();
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int c;
        int i;
        for (i = 0; i < len && (c = this.read()) != -1; ++i) {
            cbuf[i + off] = (char)c;
        }
        if (i == 0) {
            return -1;
        }
        return i;
    }

    public static void main(String[] args) throws Exception {
        int c;
        if (args.length != 2) {
            Logger.getDefaultLog().error("Usage: DelimReader file delimeter");
            System.exit(1);
        }
        FileReader r = new FileReader(args[0]);
        DelimReader me = new DelimReader(r, args[1]);
        while ((c = me.read()) != -1) {
            System.out.print((char)c);
        }
        me.close();
        Logger.getDefaultLog().log("\nChars after delim:");
        while ((c = ((Reader)r).read()) != -1) {
            System.out.print((char)c);
        }
        ((Reader)r).close();
    }
}

