/*
 * Decompiled with CFR 0.152.
 */
package dd.util;

import dd.sim.Map;
import dd.sim.MapCell;
import dd.util.FishbanksConstants;
import java.util.Iterator;

public class FishbanksSupport
implements FishbanksConstants {
    private static final int MAX_DEEP_OCEAN_CATCH = 200;
    private static final int MAX_COASTAL_WATERS_CATCH = 150;
    public static final double CATCH_VARIANCE = 0.1;
    public static final double CATCH_OFFSET = 0.05;
    private static final float DEEP_OCEAN_REGEN_RATE = 1.5f;
    private static final float MAX_DEEP_OCEAN_FISH = 100000.0f;
    private static final float COASTAL_WATERS_REGEN_RATE = 1.2f;
    private static final float MAX_COASTAL_WATERS_FISH = 50000.0f;

    public static void startupMap(Map map, int numTeams, float startingBalance, int coastalWaterFish, int deepOceanFish) {
        FishbanksSupport.setNumTeams(map, numTeams);
        String[] teamNames = new String[]{"zero", "Team One", "Team Two", "Team Three", "Team Four", "Team Five", "Team Six", "Team Seven", "Team Eight", "Team Nine", "Team Ten", "Team Eleven", "Team Twelve"};
        for (int i = 1; i <= numTeams; ++i) {
            if (i < teamNames.length) {
                FishbanksSupport.setTeamName(map, i, teamNames[i]);
            } else {
                FishbanksSupport.setTeamName(map, i, "Team " + i);
            }
            FishbanksSupport.setTeamMoney(map, i, startingBalance);
        }
        FishbanksSupport.setFish(map, "deep ocean", deepOceanFish);
        FishbanksSupport.setFish(map, "coastal waters", coastalWaterFish);
    }

    public static boolean hasBoat(MapCell cell) {
        return cell.getAttribute("boat", -1.0f) != -1.0f;
    }

    public static boolean hasBoat(MapCell cell, int teamNum) {
        return FishbanksSupport.getBoat(cell) == teamNum;
    }

    public static int getBoat(MapCell cell) {
        return (int)cell.getAttribute("boat", -1.0f);
    }

    public static void addBoat(MapCell cell, int teamNum) {
        if (FishbanksSupport.getExtraBoats(cell.getMap(), teamNum) > 0) {
            cell.setAttribute("boat", teamNum);
            cell.setAttribute("boat", cell.getMap().getLayer(FishbanksSupport.getCellType(cell)), teamNum);
        }
    }

    public static void removeBoat(MapCell cell) {
        cell.setAttribute("boat", -1.0f);
        cell.setAttribute("boat", cell.getMap().getLayer(FishbanksSupport.getCellType(cell)), -1.0f);
    }

    public static String getCellType(MapCell cell) {
        return (String)cell.getObjectAttribute("type");
    }

    public static int getExtraBoats(Map map, int teamNum) {
        return FishbanksSupport.getTeamBoats(map, teamNum) - FishbanksSupport.getBoatCount(map, "deep ocean", teamNum) - FishbanksSupport.getBoatCount(map, "coastal waters", teamNum) - FishbanksSupport.getBoatCount(map, "land", teamNum);
    }

    public static int getBoatCount(Map map) {
        int total = 0;
        for (int i = 1; i <= FishbanksSupport.getNumTeams(map); ++i) {
            total += FishbanksSupport.getTeamBoats(map, i);
        }
        return total;
    }

    public static int getBoatCount(Map map, String region) {
        return map.getLayer(region).cellsWithValuesInRange("boat", 1.0f, FishbanksSupport.getNumTeams(map)).size();
    }

    public static Iterator getBoatIterator(Map map, String region) {
        return map.getLayer(region).cellsWithValuesInRange("boat", 1.0f, FishbanksSupport.getNumTeams(map)).iterator();
    }

    public static int getBoatCount(Map map, String region, int teamNum) {
        return map.getLayer(region).cellsWithValuesInRange("boat", teamNum, teamNum).size();
    }

    public static void setNumTeams(Map map, int numTeams) {
        map.setAttribute("number of teams", numTeams);
    }

    public static int getNumTeams(Map map) {
        return (int)map.getAttribute("number of teams");
    }

    public static int getTeamBoats(Map map, int teamNum) {
        return (int)map.getAttribute("team" + teamNum + "boats");
    }

    public static void setTeamBoats(Map map, int teamNum, int numBoats) {
        map.setAttribute("team" + teamNum + "boats", numBoats);
    }

    public static float getTeamMoney(Map map, int teamNum) {
        return map.getAttribute("team" + teamNum + "money");
    }

    public static void setTeamMoney(Map map, int teamNum, float money) {
        map.setAttribute("team" + teamNum + "money", money);
    }

    public static String getTeamName(Map map, int teamNum) {
        return (String)map.getObjectAttribute("team" + teamNum + "name");
    }

    public static void setTeamName(Map map, int teamNum, String teamName) {
        map.setAttribute("team" + teamNum + "name", teamName);
    }

    public static void doOneTurn(Map map) {
        FishbanksSupport.catchFish(map);
        FishbanksSupport.regenerateFish(map);
        FishbanksSupport.updateTeamAssets(map);
    }

    private static void catchFish(Map map) {
        int team;
        MapCell cell;
        Iterator cells;
        int actualCatch;
        for (int i = 1; i <= FishbanksSupport.getNumTeams(map); ++i) {
            FishbanksSupport.setFishCaught(map, i, "deep ocean", 0);
            FishbanksSupport.setFishCaught(map, i, "coastal waters", 0);
        }
        int boats = FishbanksSupport.getBoatCount(map, "deep ocean");
        int fishCaught = Math.min(200 * boats, FishbanksSupport.getFish(map, "deep ocean"));
        if ((fishCaught = (int)((double)fishCaught + (Math.random() * 0.1 - 0.05) * (double)fishCaught)) > 0) {
            actualCatch = fishCaught / boats;
            cells = FishbanksSupport.getBoatIterator(map, "deep ocean");
            while (cells.hasNext()) {
                cell = (MapCell)cells.next();
                team = FishbanksSupport.getBoat(cell);
                FishbanksSupport.addFishCaught(map, team, "deep ocean", actualCatch);
            }
            FishbanksSupport.setFish(map, "deep ocean", FishbanksSupport.getFish(map, "deep ocean") - actualCatch * boats);
        }
        boats = FishbanksSupport.getBoatCount(map, "coastal waters");
        fishCaught = Math.min(150 * boats, FishbanksSupport.getFish(map, "coastal waters"));
        if ((fishCaught = (int)((double)fishCaught + (Math.random() * 0.1 - 0.05) * (double)fishCaught)) > 0) {
            actualCatch = fishCaught / boats;
            cells = FishbanksSupport.getBoatIterator(map, "coastal waters");
            while (cells.hasNext()) {
                cell = (MapCell)cells.next();
                team = FishbanksSupport.getBoat(cell);
                FishbanksSupport.addFishCaught(map, team, "coastal waters", actualCatch);
            }
            FishbanksSupport.setFish(map, "coastal waters", FishbanksSupport.getFish(map, "coastal waters") - actualCatch * boats);
        }
    }

    private static void catchFish1(Map map) {
        int team;
        int actualCatch;
        MapCell cell;
        for (int i = 1; i <= FishbanksSupport.getNumTeams(map); ++i) {
            FishbanksSupport.setFishCaught(map, i, "deep ocean", 0);
            FishbanksSupport.setFishCaught(map, i, "coastal waters", 0);
        }
        int fishCaught = Math.min(200, FishbanksSupport.getFish(map, "deep ocean") / FishbanksSupport.getBoatCount(map, "deep ocean"));
        Iterator cells = FishbanksSupport.getBoatIterator(map, "deep ocean");
        while (cells.hasNext()) {
            cell = (MapCell)cells.next();
            actualCatch = (int)((double)fishCaught + (Math.random() * 0.1 - 0.05) * (double)fishCaught);
            if (actualCatch == 0 || FishbanksSupport.getFish(map, "deep ocean") < actualCatch) continue;
            team = FishbanksSupport.getBoat(cell);
            FishbanksSupport.addFishCaught(map, team, "deep ocean", actualCatch);
            FishbanksSupport.setFish(map, "deep ocean", FishbanksSupport.getFish(map, "deep ocean") - actualCatch);
        }
        fishCaught = Math.min(150, FishbanksSupport.getFish(map, "coastal waters") / FishbanksSupport.getBoatCount(map, "coastal waters"));
        cells = FishbanksSupport.getBoatIterator(map, "coastal waters");
        while (cells.hasNext()) {
            cell = (MapCell)cells.next();
            actualCatch = (int)((double)fishCaught + (Math.random() * 0.1 - 0.05) * (double)fishCaught);
            if (actualCatch == 0 || FishbanksSupport.getFish(map, "coastal waters") < actualCatch) continue;
            team = FishbanksSupport.getBoat(cell);
            FishbanksSupport.addFishCaught(map, team, "coastal waters", actualCatch);
            FishbanksSupport.setFish(map, "coastal waters", FishbanksSupport.getFish(map, "coastal waters") - actualCatch);
        }
    }

    private static void setFishCaught(Map map, int teamNum, String region, int fish) {
        map.setAttribute(region + "teamCatch" + teamNum, fish);
    }

    public static int getFishCaught(Map map, int teamNum, String region) {
        return (int)map.getAttribute(region + "teamCatch" + teamNum, 0.0f);
    }

    private static void addFishCaught(Map map, int teamNum, String region, int deltaFish) {
        FishbanksSupport.setFishCaught(map, teamNum, region, FishbanksSupport.getFishCaught(map, teamNum, region) + deltaFish);
    }

    private static void updateTeamAssets(Map map) {
    }

    private static void regenerateFish(Map map) {
        FishbanksSupport.setFish(map, "deep ocean", Math.min((float)FishbanksSupport.getFish(map, "deep ocean") * 1.5f, 100000.0f));
        FishbanksSupport.setFish(map, "coastal waters", Math.min((float)FishbanksSupport.getFish(map, "coastal waters") * 1.2f, 50000.0f));
    }

    private static void setFish(Map map, String region, float count) {
        map.getLayer(region).setAttribute("fish", count);
    }

    private static int getFish(Map map, String region) {
        return (int)map.getLayer(region).getAttribute("fish");
    }
}

