/*
 * Decompiled with CFR 0.152.
 */
package dd.util;

import dd.sim.Layer;
import dd.sim.Map;
import dd.sim.MapCell;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class FreewaySupport {
    public static final int[][] scoreTable = new int[][]{{5, 3, 1, 1, 1}, {1, 1, 1, 3, 5}, {1, 3, 5, 1, 1}, {7, 1, 1, 1, 1}, {1, 7, 1, 1, 1}, {1, 1, 7, 1, 1}};
    public static HashMap playerLookup = new HashMap();

    public static float scoreForPlayer(String player, float residential, float business, float hills, float historic, float dig) {
        int[] scoreLine = (int[])playerLookup.get(player);
        return (float)scoreLine[0] * residential + (float)scoreLine[1] * business + (float)scoreLine[2] * hills + (float)scoreLine[3] * historic + (float)scoreLine[4] * dig;
    }

    public static float scoreForPlayer(String player, MapCell cell, Layer features) {
        return FreewaySupport.scoreForPlayer(player, cell.getAttribute("residential", features, 0.0f), cell.getAttribute("business", features, 0.0f), cell.getAttribute("hills", features, 0.0f), cell.getAttribute("historic", features, 0.0f), cell.getAttribute("dig", features, 0.0f));
    }

    public static int scoreForPlayer(String player, Map map) {
        Layer features = map.getLayer("features");
        Iterator iter = map.getCells().iterator();
        int scoreSoFar = 0;
        while (iter.hasNext()) {
            MapCell curCell = (MapCell)iter.next();
            if (!FreewaySupport.hasRoad(curCell, player)) continue;
            scoreSoFar += (int)FreewaySupport.scoreForPlayer(player, curCell, features) + 5;
        }
        return scoreSoFar;
    }

    public static String hasRoad(MapCell cell) {
        boolean found = false;
        if (cell == null) {
            return null;
        }
        Layer roads = cell.getMap().createLayer("roads");
        java.util.Map attrs = cell.getLayerAttributes(roads);
        Iterator iter = attrs.keySet().iterator();
        String k = null;
        while (iter.hasNext()) {
            k = (String)iter.next();
            Object o = attrs.get(k);
            if (!(o instanceof Number) || ((Number)o).floatValue() != 1.0f) continue;
            found = true;
            break;
        }
        if (!found) {
            k = null;
        }
        return k;
    }

    public static boolean hasRoad(MapCell cell, String player) {
        if (cell == null) {
            return false;
        }
        Layer roads = cell.getMap().createLayer("roads");
        return cell.getAttribute(player, roads, 0.0f) != 0.0f;
    }

    public static List allRoads(MapCell cell) {
        if (cell == null) {
            return new ArrayList();
        }
        Layer roads = cell.getMap().createLayer("roads");
        return cell.attributesInRange(roads, 1.0f, 1.0f);
    }

    public static Map readMap(String fileName) throws IOException {
        String curLine;
        BufferedReader in = new BufferedReader(new FileReader(fileName));
        int rows = Integer.parseInt(in.readLine());
        int cols = Integer.parseInt(in.readLine());
        Map map = new Map(rows, cols);
        Layer features = map.createLayer("features");
        while ((curLine = in.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(curLine);
            int row = Integer.parseInt(st.nextToken()) - 1;
            int column = Integer.parseInt(st.nextToken()) - 1;
            int business = Integer.parseInt(st.nextToken());
            int residential = Integer.parseInt(st.nextToken());
            int historic = Integer.parseInt(st.nextToken());
            int hills = Integer.parseInt(st.nextToken());
            int dig = Integer.parseInt(st.nextToken());
            MapCell curCell = map.cellAt(row, column);
            curCell.setAttribute("residential", features, residential);
            curCell.setAttribute("business", features, business);
            curCell.setAttribute("hills", features, hills);
            curCell.setAttribute("historic", features, historic);
            curCell.setAttribute("dig", features, dig);
        }
        return map;
    }

    static {
        playerLookup.put("Representative", scoreTable[0]);
        playerLookup.put("Archaeologist", scoreTable[1]);
        playerLookup.put("Taxpayer", scoreTable[2]);
        playerLookup.put("Resident", scoreTable[3]);
        playerLookup.put("Merchant", scoreTable[4]);
        playerLookup.put("City Engineer", scoreTable[5]);
    }
}

