/*
 * Decompiled with CFR 0.152.
 */
package dd.util;

import dd.sim.MapCell;
import dd.sim.SimObject;

public class HexCoordinate
extends SimObject {
    public int f;
    public int g;
    public int h;

    public HexCoordinate() {
        this.h = 0;
        this.g = 0;
        this.f = 0;
    }

    public HexCoordinate(MapCell cell) {
        this.f = -cell.getColumn();
        this.g = cell.getRow() - cell.getColumn() / 2;
        this.h = 0;
        this.canonicalize();
    }

    public String toString() {
        return "(" + this.f + "," + this.g + "," + this.h + ")";
    }

    public void canonicalize() {
        if (this.f == this.g && this.g == this.h) {
            this.h = 0;
            this.g = 0;
            this.f = 0;
            return;
        }
        if (this.f == this.g) {
            this.h -= this.g;
            this.g = 0;
            this.f = 0;
            return;
        }
        if (this.g == this.h) {
            this.f -= this.h;
            this.h = 0;
            this.g = 0;
            return;
        }
        if (this.h == this.f) {
            this.g -= this.f;
            this.f = 0;
            this.h = 0;
            return;
        }
        int min = this.f < this.g ? this.f : this.g;
        min = this.h < min ? this.h : min;
        int max = this.f > this.g ? this.f : this.g;
        int n = max = this.h > max ? this.h : max;
        if (this.f > min && this.f < max) {
            this.g -= this.f;
            this.h -= this.f;
            this.f -= this.f;
            return;
        }
        if (this.g < max && this.g > min) {
            this.f -= this.g;
            this.h -= this.g;
            this.g -= this.g;
            return;
        }
        this.f -= this.h;
        this.g -= this.h;
        this.h -= this.h;
    }

    public int magnitude() {
        this.canonicalize();
        return Math.abs(this.f) + Math.abs(this.g) + Math.abs(this.h);
    }

    public static int distance(HexCoordinate here, HexCoordinate there) {
        HexCoordinate dist = new HexCoordinate();
        dist.f = here.f - there.f;
        dist.g = here.g - there.g;
        dist.h = here.h - there.h;
        return dist.magnitude();
    }

    public void test() {
        this.debug(this.toString());
        this.canonicalize();
        this.debug(this.toString());
        this.debug("--");
    }

    public static void main(String[] args) {
        HexCoordinate c = new HexCoordinate();
        c.f = 1;
        c.g = 1;
        c.h = 1;
        c.test();
        c.f = 3;
        c.g = 0;
        c.h = 1;
        c.test();
        HexCoordinate d = new HexCoordinate();
        d.f = 1;
        d.g = 3;
        d.h = 2;
        d.test();
        c.debug("" + HexCoordinate.distance(c, d));
    }
}

