/*
 * Decompiled with CFR 0.152.
 */
package dd.util;

import dd.net.TurnServer;
import dd.ui.GameSupport;
import dd.ui.InstructorInterface;
import dd.util.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.JFrame;

public class InstructorSupport {
    private static final int PLAYERS_PER_GAME = 4;
    public JFrame frame;
    public InstructorInterface gui;

    public void startServer() {
        this.frame.dispose();
        String venueName = this.gui.getVenueName();
        int numGames = this.gui.getNumGames();
        String[] gameNames = new String[numGames];
        String[] gameFiles = new String[numGames];
        int[] humanPlayers = new int[numGames];
        for (int i = 0; i < numGames; ++i) {
            gameNames[i] = this.gui.getGameName(i);
            gameFiles[i] = this.gui.getGameFile(i);
            humanPlayers[i] = this.gui.getHumans(i);
        }
        this.gui.showRunningServerFrame();
        this.startServer(venueName, numGames, gameNames, gameFiles, humanPlayers, this.gui.getSaveDirectory(), this.gui.getDebugFile());
    }

    public void startServer(String venueName, int numGames, String[] gameNames, String[] gameFiles, int[] humanPlayers, File saveDir, File debugFile) {
        if (debugFile != null) {
            try {
                Logger.getDefaultLog().setOutput(debugFile);
            }
            catch (IOException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        TurnServer ts = TurnServer.startServer(false, venueName);
        if (saveDir != null) {
            ts.setSaveDir(saveDir.getPath());
        }
        for (int i = 0; i < numGames; ++i) {
            ts.createGame(gameNames[i], humanPlayers[i], gameFiles[i]);
        }
    }

    private void display(String message) {
        System.out.print(message);
        System.out.flush();
    }

    public void startTextMode() {
        File saveDir = null;
        File debugFile = null;
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        String line = null;
        try {
            boolean needInput = true;
            do {
                this.display("Venue name (15 chars max., letters and spaces): ");
                line = stdin.readLine();
                if (line != null && line.matches("[A-Za-z0-9 ]{1,15}")) {
                    needInput = false;
                    continue;
                }
                this.display("Venue name must be 15 characters or less and may only contane letters,\nnumbers, and spaces.\n");
            } while (needInput);
            String venueName = line;
            needInput = true;
            do {
                this.display("Number of games to create: ");
                line = stdin.readLine();
                if (line != null && line.matches("\\d+")) {
                    needInput = false;
                    continue;
                }
                this.display("Number of games must be a number.\n");
            } while (needInput);
            int numGames = Integer.parseInt(line);
            String[] gameNames = new String[numGames];
            String[] gameFiles = new String[numGames];
            int[] humanPlayers = new int[numGames];
            for (int i = 0; i < numGames; ++i) {
                String defaultName = "Team " + (i + 1);
                this.display("Game " + (i + 1) + " name (Default: [" + defaultName + "]): ");
                line = stdin.readLine();
                gameNames[i] = line == null || line.equals("") ? defaultName : line;
                needInput = true;
                do {
                    this.display("Number of human players for [" + gameNames[i] + "] (Default: " + 4 + "): ");
                    line = stdin.readLine();
                    if (line == null || line.equals("")) {
                        humanPlayers[i] = 4;
                        needInput = false;
                        continue;
                    }
                    if (line.matches("\\d+")) {
                        humanPlayers[i] = Integer.parseInt(line);
                        if (humanPlayers[i] > 4) {
                            this.display("Number of players must be less than 4.\n");
                            continue;
                        }
                        needInput = false;
                        continue;
                    }
                    this.display("Number of players must be a number.\n");
                } while (needInput);
            }
            this.display("Name of directory to save games (Default: current directory): ");
            line = stdin.readLine();
            if (line != null && !line.equals("")) {
                saveDir = new File(line);
            }
            this.display("Name of file to store debugging (Default: output to console): ");
            line = stdin.readLine();
            if (line != null && !line.equals("")) {
                debugFile = new File(line);
            }
            this.startServer(venueName, numGames, gameNames, gameFiles, humanPlayers, saveDir, debugFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void startGui() {
        this.gui = new InstructorInterface();
        this.gui.setTarget(this);
        this.frame = new JFrame("DD Server Configuration");
        this.frame.setDefaultCloseOperation(3);
        this.frame.getContentPane().add(this.gui);
        this.frame.pack();
        this.frame.setVisible(true);
        GameSupport.centerWindow(this.frame);
    }

    public static void main(String[] args) {
        if (args.length >= 1 && args[0].equals("-nogui")) {
            new InstructorSupport().startTextMode();
        } else {
            new InstructorSupport().startGui();
        }
    }
}

