/*
 * Decompiled with CFR 0.152.
 */
package dd.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class Logger {
    private static Logger defaultLog = new Logger();
    public static final boolean LOG_DEBUG = true;
    public static final boolean LOG_LOG = true;
    public static final boolean LOG_WARNING = true;
    public static final boolean LOG_ERROR = true;
    private static PrintStream output = System.out;

    private Logger() {
    }

    public static Logger getDefaultLog() {
        return defaultLog;
    }

    public void setOutput(File outFile) throws IOException {
        output = new PrintStream(new FileOutputStream(outFile));
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                output.close();
            }
        });
    }

    public void debug(String debugMessage) {
        output.println("DEBUG: " + debugMessage);
    }

    public void log(String logMessage) {
        output.println(logMessage);
    }

    public void warning(String warningMessage) {
        Exception e = new Exception();
        StackTraceElement[] st = e.getStackTrace();
        output.print(st[2].getFileName());
        output.print(":");
        output.print(st[1].getLineNumber());
        output.println(" WARNING: " + warningMessage);
    }

    public void error(String errorMessage) {
        Exception e = new Exception();
        StackTraceElement[] st = e.getStackTrace();
        output.print(st[2].getFileName());
        output.print(":");
        output.print(st[1].getLineNumber());
        output.println(" ERROR: " + errorMessage);
    }
}

