/*
 * Decompiled with CFR 0.152.
 */
package dd.util;

import dd.hurricane.Main;
import dd.sim.Layer;
import dd.sim.Map;
import dd.sim.MapCell;
import dd.util.Logger;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;

public class MapMaker {
    private String inFileName;
    private String outFileName;
    private Random rng;
    private Map map;
    private HashMap hash;

    public MapMaker(String inFile, String outFile) {
        this.inFileName = inFile;
        this.outFileName = outFile;
        this.rng = new Random(2222L);
        this.map = new Map(10, 10);
        this.hash = new HashMap();
        for (int row = 0; row < 10; ++row) {
            for (int col = 0; col < 10; ++col) {
                String[] array = new String[19];
                for (int i = 0; i < 19; ++i) {
                    array[i] = "none";
                }
                this.hash.put("<" + row + "," + col + ">", array);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void convert() {
        block21: {
            BufferedReader in;
            block20: {
                int i;
                String curLine;
                in = null;
                in = new BufferedReader(new FileReader(this.inFileName));
                while ((curLine = in.readLine()) != null) {
                    String[] lineTokens = curLine.trim().split("\\s+");
                    MapCell curCell = this.map.cellAt(lineTokens[0]);
                    if (curCell == null) {
                        Logger.getDefaultLog().error("Invalid location " + lineTokens[0]);
                        continue;
                    }
                    String[] nameTokens = lineTokens[1].split(":");
                    Layer layer = this.map.createLayer(nameTokens[0]);
                    String attributeName = nameTokens[nameTokens.length - 1];
                    if ("landuse".equals(nameTokens[0])) {
                        int num = Integer.parseInt(lineTokens[2]);
                        curCell.setAttribute(attributeName, layer, num);
                        String[] array = (String[])this.hash.get(lineTokens[0]);
                        for (i = 3; i < lineTokens.length; ++i) {
                            int posn = Integer.parseInt(lineTokens[i]);
                            if (!"none".equals(array[posn])) {
                                curCell.warning("Clobbering " + array[posn] + " with " + attributeName + " at display index " + i);
                            }
                            array[posn] = attributeName;
                        }
                        this.hash.put(lineTokens[0], array);
                        continue;
                    }
                    if (lineTokens.length > 3) {
                        ArrayList<String> list = new ArrayList<String>();
                        for (int i2 = 2; i2 < lineTokens.length; ++i2) {
                            list.add(lineTokens[i2]);
                        }
                        curCell.setAttribute(attributeName, layer, list);
                        continue;
                    }
                    if (lineTokens[2].matches("^\\d+$")) {
                        int num = Integer.parseInt(lineTokens[2]);
                        curCell.setAttribute(attributeName, layer, num);
                        continue;
                    }
                    if (lineTokens[2].matches("^\\d+.\\d+$")) {
                        float num = Float.parseFloat(lineTokens[2]);
                        curCell.setAttribute(attributeName, layer, num);
                        continue;
                    }
                    curCell.setAttribute(attributeName, layer, lineTokens[2]);
                }
                this.placeIcons();
                Layer hazard = this.map.getLayer("hazard");
                hazard.setAttribute("wind", 0.5f);
                String[] lu = Main.luNames;
                for (i = 0; i < lu.length; ++i) {
                    hazard.setAttribute(lu[i] + "WindVulnerability", 0.5f);
                    hazard.setAttribute(lu[i] + "WaterVulnerability", 0.5f);
                }
                this.map.setAttribute("bgImage", "background.png");
                this.map.setAttribute("transitImage", "highway-ferry.png");
                this.map.setAttribute("labelImage", "labels.png");
                this.map.writeXML(this.outFileName);
                Object var13_18 = null;
                if (in == null) break block20;
                try {
                    in.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
            }
            System.exit(0);
            {
                break block21;
                catch (IOException e) {
                    e.printStackTrace();
                    Object var13_19 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                    }
                    System.exit(0);
                }
            }
            catch (Throwable throwable) {
                Object var13_20 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                System.exit(0);
                throw throwable;
            }
        }
    }

    public void placeIcons() {
        String[] lu = new String[]{"openspace", "water", "industrial", "road", "store", "hotel", "house", "condo"};
        Layer layer = this.map.getLayer("landuse");
        Iterator iter = this.map.getCells().iterator();
        while (iter.hasNext()) {
            MapCell c = (MapCell)iter.next();
            String[] iconArray = (String[])this.hash.get("<" + c.getRow() + "," + c.getColumn() + ">");
            int nones = 0;
            for (int i = 0; i < 19; ++i) {
                if (!"none".equals(iconArray[i])) continue;
                ++nones;
            }
            for (int use = 0; use < lu.length; ++use) {
                int set = 0;
                for (int i = 0; i < 19; ++i) {
                    if (!lu[use].equals(iconArray[i])) continue;
                    ++set;
                }
                int total = (int)c.getAttribute(lu[use], layer, 0.0f);
                if (set > 0 && set != total) {
                    c.warning("Landuse " + lu[use] + " has " + total + " units declared but only " + set + " placed.");
                }
                for (int i = set; i < total; ++i) {
                    if (nones < 1) {
                        c.fatal("Attempt to place a landuse in a full cell");
                    }
                    boolean flag = true;
                    while (flag) {
                        int loc = this.rng.nextInt(19);
                        if (!"none".equals(iconArray[loc])) continue;
                        flag = false;
                        --nones;
                        iconArray[loc] = lu[use];
                    }
                }
            }
            ArrayList<String> icons = new ArrayList<String>();
            for (int i = 0; i < 19; ++i) {
                icons.add(iconArray[i]);
            }
            c.setAttribute("luArray", layer, icons);
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            Logger.getDefaultLog().error("Usage: MapMaker inFile [outFile]");
            System.exit(1);
        }
        String in = args[0];
        String out = args.length == 1 ? in + ".map" : args[1];
        MapMaker me = new MapMaker(in, out);
        me.convert();
    }
}

