/*
 * Decompiled with CFR 0.152.
 */
package dd.util;

import dd.sim.SimObject;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Registry
extends HashMap
implements PropertyChangeListener {
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public Registry() {
    }

    public Registry(Map map) {
        super(map);
        Iterator iter = map.values().iterator();
        while (iter.hasNext()) {
            ((SimObject)iter.next()).addPropertyChangeListener(this);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void propertyChange(PropertyChangeEvent e) {
        this.firePropertyChange("registryElementChanged", e.getSource(), e.getPropertyName());
    }

    public String getID(Object o) {
        Set s = this.keySet();
        Iterator iter = s.iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            if (this.get(key) != o) continue;
            return (String)key;
        }
        return null;
    }

    public void clear() {
        super.clear();
        this.firePropertyChange("registryCleared", "all", "none");
    }

    public Object remove(Object o) {
        Object retVal = super.remove(o);
        this.firePropertyChange("registryElementRemoved", o, null);
        return retVal;
    }

    public void put(Object key, SimObject value) {
        super.put(key, value);
        this.firePropertyChange("registryElementAdded", null, value);
        value.addPropertyChangeListener(this);
    }

    public void put(SimObject value) {
        this.put("h" + value.hashCode(), value);
    }
}

