/*
 * Decompiled with CFR 0.152.
 */
package dd.util;

import dd.sim.Layer;
import dd.sim.Map;
import dd.sim.MapCell;
import dd.sim.Proposal;
import dd.sim.SimObject;
import dd.util.AttributeHelper;
import dd.util.XMLHelper;
import java.io.Reader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SimXMLReader {
    private Document doc;

    public SimXMLReader(String fileName) {
        this.doc = XMLHelper.makeDocument(fileName);
    }

    public SimXMLReader(Reader reader) {
        this.doc = XMLHelper.makeDocument(reader);
    }

    public SimObject read() {
        if (this.doc == null) {
            return null;
        }
        return SimXMLReader.read(this.doc.getDocumentElement());
    }

    public static SimObject read(Element root) {
        String elementName = root.getNodeName();
        if ("map".equals(elementName)) {
            return SimXMLReader.readMapXML(root);
        }
        if ("layer".equals(elementName)) {
            return SimXMLReader.readLayerXML(root);
        }
        if ("cell".equals(elementName)) {
            return SimXMLReader.readMapCellXML(root, new Map());
        }
        if ("proposal".equals(elementName)) {
            return SimXMLReader.readProposalXML(root);
        }
        if ("sim-object".equals(elementName)) {
            return SimXMLReader.readSimObjectXML(root);
        }
        return null;
    }

    public static Map readMapXML(Node node) {
        Node cells;
        Node layers;
        int w = XMLHelper.parseXMLInt(XMLHelper.getNodeAttribute(node, "width"));
        int h = XMLHelper.parseXMLInt(XMLHelper.getNodeAttribute(node, "height"));
        Map map = new Map(h, w);
        Node n = XMLHelper.findChild(node, "attributes");
        if (n != null) {
            map.setAttributes(AttributeHelper.readAttributes(n, map));
        }
        if ((layers = XMLHelper.findChild(node, "layers")) != null) {
            for (Node layerNode = layers.getFirstChild(); layerNode != null; layerNode = layerNode.getNextSibling()) {
                if (!layerNode.getNodeName().equals("layer")) continue;
                Layer l = SimXMLReader.readLayerXML(layerNode);
                map.addLayer(l);
            }
        }
        if ((cells = XMLHelper.findChild(node, "cells")) != null) {
            for (Node cellNode = cells.getFirstChild(); cellNode != null; cellNode = cellNode.getNextSibling()) {
                if (!cellNode.getNodeName().equals("cell")) continue;
                MapCell c = SimXMLReader.readMapCellXML(cellNode, map);
                map.setCellAt(c.getRow(), c.getColumn(), c);
            }
        }
        map.makeCache();
        return map;
    }

    public static Proposal readProposalXML(Node node) {
        Proposal proposal = new Proposal();
        Map map = new Map();
        try {
            String proposalType = XMLHelper.getNodeAttribute(node, "class");
            if (proposalType != null) {
                Object obj = null;
                Class<?> objectClass = Class.forName(proposalType);
                obj = objectClass.newInstance();
                proposal = obj;
            }
        }
        catch (Exception e) {
            map.error("Could not deserialize proposal");
        }
        Node n = XMLHelper.findChild(node, "attributes");
        if (n != null) {
            proposal.setAttributes(AttributeHelper.readAttributes(n, map));
        }
        return proposal;
    }

    public static SimObject readSimObjectXML(Node node) {
        Map map = new Map();
        String objectType = XMLHelper.getNodeAttribute(node, "class");
        SimObject obj = null;
        try {
            Class<?> objectClass = Class.forName(objectType);
            obj = (SimObject)objectClass.newInstance();
            Node n = XMLHelper.findChild(node, "attributes");
            if (n != null) {
                obj.setAttributes(AttributeHelper.readAttributes(n, map));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static Layer readLayerXML(Node node) {
        String name = XMLHelper.getNodeAttribute(node, "name");
        Layer layer = new Layer(name);
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!child.getNodeName().equals("attributes")) continue;
            layer.setAttributes(AttributeHelper.readAttributes(child, null));
        }
        return layer;
    }

    public static MapCell readMapCellXML(Node node, Map map) {
        int r = XMLHelper.parseXMLInt(XMLHelper.getNodeAttribute(node, "row"));
        int c = XMLHelper.parseXMLInt(XMLHelper.getNodeAttribute(node, "column"));
        double x = XMLHelper.parseXMLDouble(XMLHelper.getNodeAttribute(node, "x"));
        double y = XMLHelper.parseXMLDouble(XMLHelper.getNodeAttribute(node, "y"));
        MapCell cell = new MapCell(map, r, c);
        cell.setX(x);
        cell.setY(y);
        Node attributes = XMLHelper.findChild(node, "attributes");
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!child.getNodeName().equals("attributes")) continue;
            cell.setAttributes(AttributeHelper.readAttributes(child, map));
        }
        return cell;
    }
}

