/*
 * Decompiled with CFR 0.152.
 */
package dd.util;

import dd.sim.Layer;
import dd.sim.Map;
import dd.sim.MapCell;
import dd.sim.Proposal;
import dd.sim.SimObject;
import dd.util.AttributeHelper;
import dd.util.XMLHelper;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SimXMLWriter {
    private Document out;
    private SimObject source;

    public SimXMLWriter(SimObject object) {
        this.source = object;
    }

    public void write(String fileName) {
        XMLHelper.writeXMLFile(fileName, this.getXMLNode());
    }

    public String write() {
        return XMLHelper.writeXMLString(this.getXMLNode());
    }

    public void setDocument(Document d) {
        this.out = d;
    }

    public Node getXMLNode() {
        if (this.source == null) {
            return null;
        }
        if (this.out == null) {
            this.out = XMLHelper.makeDocument();
        }
        if (this.source instanceof Map) {
            return this.writeMapXML((Map)this.source);
        }
        if (this.source instanceof MapCell) {
            return this.writeMapCellXML((MapCell)this.source);
        }
        if (this.source instanceof Layer) {
            return this.writeLayerXML((Layer)this.source);
        }
        if (this.source instanceof Proposal) {
            return this.writeProposalXML((Proposal)this.source);
        }
        return this.writeSimObjectXML(this.source);
    }

    public Node writeSimObjectXML(SimObject obj) {
        Element newNode = XMLHelper.createNode(this.out, "sim-object", "class", obj.getClass().getName(), null);
        newNode.appendChild(AttributeHelper.writeAttributes(this.out, obj.getAttributes()));
        return newNode;
    }

    public Node writeProposalXML(Proposal proposal) {
        Element newNode = XMLHelper.createNode(this.out, "proposal");
        newNode.setAttribute("class", proposal.getClass().getName());
        newNode.appendChild(AttributeHelper.writeAttributes(this.out, proposal.getAttributes()));
        return newNode;
    }

    public Node writeMapXML(Map map) {
        Element newNode = XMLHelper.createNode(this.out, "map", "width", Integer.toString(map.getMapWidth()), null);
        newNode.setAttribute("height", Integer.toString(map.getMapHeight()));
        newNode.appendChild(AttributeHelper.writeAttributes(this.out, map.getAttributes()));
        Element layers = XMLHelper.createNode(this.out, "layers", newNode);
        Iterator iter = map.getLayers().iterator();
        while (iter.hasNext()) {
            layers.appendChild(this.writeLayerXML((Layer)iter.next()));
        }
        Element cells = XMLHelper.createNode(this.out, "cells", newNode);
        iter = map.getCells().iterator();
        while (iter.hasNext()) {
            cells.appendChild(this.writeMapCellXML((MapCell)iter.next()));
        }
        return newNode;
    }

    public Node writeLayerXML(Layer layer) {
        Element newNode = XMLHelper.createNode(this.out, "layer", "name", layer.getName(), null);
        newNode.appendChild(AttributeHelper.writeAttributes(this.out, layer.getAttributes()));
        return newNode;
    }

    public Node writeMapCellXML(MapCell cell) {
        Element newNode = XMLHelper.createNode(this.out, "cell");
        newNode.setAttribute("row", Integer.toString(cell.getRow()));
        newNode.setAttribute("column", Integer.toString(cell.getColumn()));
        newNode.setAttribute("x", Double.toString(cell.getX()));
        newNode.setAttribute("y", Double.toString(cell.getY()));
        newNode.appendChild(AttributeHelper.writeAttributes(this.out, cell.getAttributes()));
        return newNode;
    }
}

