/*
 * Decompiled with CFR 0.152.
 */
package dd.util;

import dd.util.SwikiStarFormatter;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.Writer;

public class SwikiLineFormatter {
    public static final int PARAGRAPH = 1;
    public static final int LIST = 2;
    public static final int TABLE = 3;
    public static final int PARSE_DISABLED = 4;
    public static final int NONE = 0;
    private BufferedReader in;
    private Writer out;
    private int curState;
    private char[] listTags;
    private int listTagLength;
    private static SwikiStarFormatter ssf;

    public SwikiLineFormatter(Reader input, Writer output) {
        this.in = new BufferedReader(input);
        this.out = output;
        this.listTags = new char[1];
        this.listTagLength = 0;
    }

    public SwikiLineFormatter(String fileName, Writer output) {
        try {
            this.in = new BufferedReader(new FileReader(fileName));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.out = output;
        this.listTags = new char[1];
        this.listTagLength = 0;
    }

    private boolean isBlank(String s) {
        return s.trim().equals("");
    }

    private void switchToState(int newState) throws IOException {
        if (this.curState != newState) {
            this.endState();
            this.startState(newState);
        }
    }

    private void startState(int newState) throws IOException {
        this.curState = newState;
        if (this.curState == 1) {
            this.out.write("<p>");
        } else if (this.curState == 3) {
            this.out.write("<table border=\"1\">\n");
        }
    }

    private void endState() throws IOException {
        if (this.curState == 1) {
            this.out.write("</p>\n");
        } else if (this.curState == 2) {
            this.closeListTags();
            this.listTagLength = 0;
        } else if (this.curState == 3) {
            this.out.write("</table>\n");
        }
    }

    private void doTableLine(String aLine) throws IOException {
        char[] lineChars = aLine.toCharArray();
        this.out.write("<tr><td>");
        int lineLen = lineChars.length;
        int lastChar = lineLen - 1;
        for (int i = 1; i < lineLen; ++i) {
            if (lineChars[i] == '|') {
                if (i == lastChar) {
                    this.out.write("</td>");
                    continue;
                }
                this.out.write("</td><td>");
                continue;
            }
            this.out.write(lineChars[i]);
        }
        this.out.write("</tr>\n");
    }

    private boolean isListChar(char ch) {
        return ch == '-' || ch == '#';
    }

    private void closeListTags() throws IOException {
        --this.listTagLength;
        while (this.listTagLength >= 0) {
            this.closeListTag(this.listTags[this.listTagLength]);
            --this.listTagLength;
        }
    }

    private void closeListTag(char curTag) throws IOException {
        if (curTag == '-') {
            this.out.write("</ul>\n");
        } else if (curTag == '#') {
            this.out.write("</ol>\n");
        }
    }

    private void openListTag(char curTag) throws IOException {
        if (curTag == '-') {
            this.out.write("<ul>\n");
        } else if (curTag == '#') {
            this.out.write("<ol>\n");
        }
    }

    private void openOrClose(char[] newListTags) throws IOException {
        int j;
        int i;
        int minLength = Math.min(this.listTagLength, newListTags.length);
        for (i = 0; i < minLength && this.listTags[i] == newListTags[i]; ++i) {
        }
        for (j = this.listTagLength - 1; j >= i; --j) {
            this.closeListTag(this.listTags[j]);
        }
        for (j = i; j < newListTags.length; ++j) {
            this.openListTag(newListTags[j]);
        }
    }

    public void doListLine(String aLine) throws IOException {
        int i = 0;
        while (this.isListChar(aLine.charAt(i))) {
            ++i;
        }
        char[] newTags = aLine.substring(0, i).toCharArray();
        this.openOrClose(newTags);
        this.listTagLength = i;
        this.listTags = newTags;
        this.out.write("<li>");
        this.out.write(aLine.substring(i));
        this.out.write("</li>\n");
    }

    public void format() throws IOException {
        String curLine;
        this.curState = 0;
        while ((curLine = this.in.readLine()) != null) {
            if (curLine.equals("<raw>")) {
                this.switchToState(4);
                continue;
            }
            if (curLine.equals("</raw>")) {
                this.switchToState(0);
                continue;
            }
            if (this.curState == 4) {
                this.out.write(curLine);
                this.out.write(10);
                continue;
            }
            if (curLine.startsWith("!!!")) {
                this.switchToState(0);
                this.out.write("<h1>");
                this.out.write(curLine.substring(3));
                this.out.write("</h1>\n");
                continue;
            }
            if (curLine.startsWith("!!")) {
                this.switchToState(0);
                this.out.write("<h2>");
                this.out.write(curLine.substring(2));
                this.out.write("</h2>\n");
                continue;
            }
            if (curLine.startsWith("!")) {
                this.switchToState(0);
                this.out.write("<h3>");
                this.out.write(curLine.substring(1));
                this.out.write("</h3>\n");
                continue;
            }
            if (curLine.startsWith("|")) {
                this.switchToState(3);
                this.doTableLine(curLine);
                continue;
            }
            if (curLine.startsWith("=")) {
                this.switchToState(0);
                this.out.write("<pre>");
                this.out.write(curLine.substring(1));
                this.out.write("</pre>\n");
                continue;
            }
            if (curLine.startsWith("_")) {
                this.switchToState(0);
                this.out.write("<hr>");
                continue;
            }
            if (curLine.startsWith("$")) {
                this.switchToState(0);
                this.out.write("<h1>");
                this.out.write(curLine.substring(1));
                this.out.write("</h1>\n");
                continue;
            }
            if (curLine.length() > 0 && this.isListChar(curLine.charAt(0))) {
                this.switchToState(2);
                this.doListLine(curLine);
                continue;
            }
            if (this.isBlank(curLine)) {
                this.switchToState(0);
                continue;
            }
            this.switchToState(1);
            this.out.write(curLine);
            this.out.write(10);
        }
        this.switchToState(0);
    }

    public static void makePipe(Reader in, Writer out) throws IOException {
        Runnable r = new Runnable(){

            public void run() {
                ssf.format();
            }
        };
        PipedWriter pw = new PipedWriter();
        PipedReader pr = new PipedReader(pw);
        ssf = new SwikiStarFormatter(in, pw);
        SwikiLineFormatter me = new SwikiLineFormatter(pr, out);
        Thread t = new Thread(r);
        t.start();
        me.format();
    }

    public static void main(String[] args) {
        try {
            InputStreamReader r = args.length == 1 ? new FileReader(args[0]) : new InputStreamReader(System.in);
            SwikiLineFormatter.makePipe(r, new OutputStreamWriter(System.out));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

