/*
 * Decompiled with CFR 0.152.
 */
package dd.util;

import dd.util.Logger;
import java.awt.Container;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;

public class SwikiStarFormatter {
    private Reader in;
    private Writer out;
    private String[] protocols = new String[]{"http:", "ftp:", "file:", "rtsp:"};
    private String[] imageExts = new String[]{".gif", ".jpg", ".png"};

    public SwikiStarFormatter(Reader input, Writer output) {
        this.in = input;
        this.out = output;
    }

    public boolean isURL(String s) {
        for (int i = 0; i < this.protocols.length; ++i) {
            if (!s.startsWith(this.protocols[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isImage(String s) {
        for (int i = 0; i < this.imageExts.length; ++i) {
            if (!s.endsWith(this.imageExts[i])) continue;
            return true;
        }
        return false;
    }

    public Image getImageRightNow(String imageName) {
        return this.getImageRightNow(imageName, null);
    }

    public Image getImageRightNow(URL imageUrl) {
        return this.getImageRightNow(null, imageUrl);
    }

    private Image getImageRightNow(String imageName, URL imageUrl) {
        MediaTracker mt = new MediaTracker(new Container());
        Toolkit tk = Toolkit.getDefaultToolkit();
        Image img = imageName != null ? tk.getImage(imageName) : tk.getImage(imageUrl);
        mt.addImage(img, 0);
        try {
            mt.waitForID(0);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            System.exit(1);
        }
        return img;
    }

    public void makeSwikiLink(String target, String altText) throws IOException {
        if (target.startsWith("+") && target.endsWith("+")) {
            target = target.substring(1, target.length() - 1);
            if (altText == null) {
                int lastSlash = target.lastIndexOf("/");
                altText = target.substring(lastSlash + 1);
            }
            this.out.write("<a href=\"");
            this.out.write(target);
            this.out.write("\">");
            this.out.write(altText);
            this.out.write("</a>");
            return;
        }
        if (this.isImage(target)) {
            URL u = null;
            if (this.isURL(target)) {
                try {
                    u = new URL(target);
                }
                catch (MalformedURLException ignored) {
                    // empty catch block
                }
            }
            String styleInfo = "";
            Image img = u != null ? this.getImageRightNow(u) : this.getImageRightNow(target);
            if (altText == null) {
                int lastSlash = target.lastIndexOf("/");
                altText = target.substring(lastSlash + 1);
            } else if (altText.equals("floatRight")) {
                styleInfo = " style=\"float: right; margin: 5px; padding: 5px; border-style: solid; border-width: 0.01in;\"";
            }
            this.out.write("<img src=\"");
            this.out.write(target);
            this.out.write("\" width=\"");
            this.out.write(Integer.toString(img.getWidth(null)));
            this.out.write("\" height=\"");
            this.out.write(Integer.toString(img.getHeight(null)));
            this.out.write("\" alt=\"[");
            this.out.write(altText);
            this.out.write("]\"");
            this.out.write(styleInfo);
            this.out.write(62);
            return;
        }
        if (altText == null) {
            altText = target;
        }
        if (!this.isURL(target)) {
            target = target.replace(' ', '_');
            target = target.replace('\n', '_');
            target = target.toLowerCase();
            target = target + ".html";
        }
        this.out.write("<a href=\"");
        this.out.write(target);
        this.out.write("\">");
        this.out.write(altText);
        this.out.write("</a>");
    }

    public void grabLink() throws IOException {
        StringBuffer altBuffer = null;
        StringBuffer nameBuffer = new StringBuffer(50);
        while (true) {
            int c;
            if ((c = this.in.read()) < 0) {
                Logger.getDefaultLog().error("Star hit EOF");
                System.exit(1);
            }
            char curChar = (char)c;
            if (c == 42) break;
            if (c == 62) {
                altBuffer = nameBuffer;
                nameBuffer = new StringBuffer(50);
                continue;
            }
            nameBuffer.append(curChar);
        }
        if (nameBuffer.length() == 0) {
            this.out.write(42);
        } else if (altBuffer == null) {
            this.makeSwikiLink(new String(nameBuffer), null);
        } else {
            this.makeSwikiLink(new String(nameBuffer), new String(altBuffer));
        }
    }

    public void format() {
        try {
            int c;
            while ((c = this.in.read()) >= 0) {
                char curChar = (char)c;
                if (curChar == '*') {
                    this.grabLink();
                    continue;
                }
                this.out.write(curChar);
            }
            this.out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String parse(String inStr) throws IOException {
        StringReader r = new StringReader(inStr);
        StringWriter w = new StringWriter(inStr.length() * 2);
        SwikiStarFormatter me = new SwikiStarFormatter(r, w);
        me.format();
        return ((Object)w).toString();
    }

    public static void main(String[] args) {
        SwikiStarFormatter me = new SwikiStarFormatter(new InputStreamReader(System.in), new OutputStreamWriter(System.out));
        me.format();
    }
}

