/*
 * Decompiled with CFR 0.152.
 */
package dd.util;

import dd.util.CountdownTimer;
import dd.util.TimedActionListener;

public abstract class TimedAction
implements TimedActionListener {
    protected String name;
    protected String description;
    protected int duration;
    protected CountdownTimer timer;

    public TimedAction() {
        this("**UNKNOWN**");
    }

    public TimedAction(String name) {
        this(name, 10);
    }

    public TimedAction(String name, int duration) {
        this(name, duration, "**NO DESCRIPTION**");
    }

    public TimedAction(String name, int duration, String description) {
        this.setName(name);
        this.setDuration(duration);
        this.setDescription(description);
        this.timer = new CountdownTimer(duration);
        this.timer.addTimedActionListener(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public CountdownTimer getTimer() {
        return this.timer;
    }

    public void start() {
        this.timer.start();
    }

    public void pause() {
        this.timer.stop();
    }

    public void resume() {
        this.timer.start();
    }

    public void reset() {
        this.timer.reset();
    }

    public void interrupt() {
        this.timer.stop();
    }

    public void timerStarted(CountdownTimer timer) {
    }

    public void timerTick(CountdownTimer timer) {
    }

    public void timerElapsed(CountdownTimer timer) {
        this.doDefaultAction();
    }

    public abstract void doDefaultAction();
}

