/*
 * Decompiled with CFR 0.152.
 */
package dd.util;

import dd.util.Logger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLHelper {
    protected static String[] convertQueryToArray(String query) {
        LinkedList<String> l = new LinkedList<String>();
        StringTokenizer st = new StringTokenizer(query, ".");
        while (st.hasMoreTokens()) {
            l.add(st.nextToken());
        }
        String[] retArray = new String[l.size()];
        l.toArray(retArray);
        return retArray;
    }

    protected static Node findNode(Node n, String[] targets, int index) {
        if (n.getNodeName().equals(targets[index])) {
            if (index == targets.length - 1) {
                return n;
            }
            NodeList l = n.getChildNodes();
            for (int i = 0; i < l.getLength(); ++i) {
                Node t = XMLHelper.findNode(l.item(i), targets, index + 1);
                if (t == null) continue;
                return t;
            }
        }
        return null;
    }

    public static Node findChild(Node n, String elementName) {
        for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!child.getNodeName().equals(elementName)) continue;
            return child;
        }
        return null;
    }

    public static Element findFirstElement(Node n) {
        for (Node child = n.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            return (Element)child;
        }
        return null;
    }

    public static Node findNode(Document d, String target) {
        String[] s = XMLHelper.convertQueryToArray(target);
        NodeList l = d.getElementsByTagName(s[0]);
        for (int i = 0; i < l.getLength(); ++i) {
            Node t = XMLHelper.findNode(l.item(i), s, 0);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public static String findString(Document d, String target) {
        Node n = XMLHelper.findNode(d, target);
        if (n != null) {
            return n.getFirstChild().getNodeValue();
        }
        return null;
    }

    public static double findDouble(Document d, String target) {
        String s = XMLHelper.findString(d, target);
        if (s == null) {
            s = "-1.0";
        }
        return XMLHelper.parseXMLDouble(s);
    }

    public static int findInt(Document d, String target) {
        String s = XMLHelper.findString(d, target);
        if (s == null) {
            s = "-1";
        }
        return XMLHelper.parseXMLInt(s);
    }

    public static String getNodeAttribute(Node node, String attributeName) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes == null) {
            return null;
        }
        Node n = attributes.getNamedItem(attributeName);
        if (n == null) {
            return null;
        }
        return n.getNodeValue();
    }

    public static double parseXMLDouble(String s) {
        double d = -1.0;
        if (s == null) {
            return d;
        }
        try {
            d = Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            Logger.getDefaultLog().error(s + " is not a number");
        }
        return d;
    }

    public static int parseXMLInt(String s) {
        int i = -1;
        if (s == null) {
            return i;
        }
        try {
            i = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            Logger.getDefaultLog().error(s + " is not a number");
        }
        return i;
    }

    public static Document makeDocument() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            Logger.getDefaultLog().error("Error invoking XML parser: " + e);
            return null;
        }
    }

    public static Document makeDocument(Reader reader) {
        try {
            DocumentBuilderFactory bf = DocumentBuilderFactory.newInstance();
            bf.setValidating(false);
            DocumentBuilder b = bf.newDocumentBuilder();
            Document d = b.parse(new InputSource(reader));
            return d;
        }
        catch (SAXException e) {
            Logger.getDefaultLog().error("Error parsing XML file: ");
            e.printStackTrace();
        }
        catch (IOException e) {
            Logger.getDefaultLog().error("Error reading file: ");
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            Logger.getDefaultLog().error("Error invoking XML parser: ");
            e.printStackTrace();
        }
        return null;
    }

    public static Document makeDocument(String fileName) {
        try {
            DocumentBuilderFactory bf = DocumentBuilderFactory.newInstance();
            bf.setValidating(false);
            DocumentBuilder b = bf.newDocumentBuilder();
            Document d = b.parse(new File(fileName));
            return d;
        }
        catch (SAXException e) {
            Logger.getDefaultLog().error("Error parsing XML file: ");
            e.printStackTrace();
        }
        catch (IOException e) {
            Logger.getDefaultLog().error("Error reading file: ");
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            Logger.getDefaultLog().error("Error invoking XML parser: ");
            e.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void writeXMLFile(String fileName, Node mainNode) {
        block11: {
            FileWriter out = null;
            out = new FileWriter(fileName);
            XMLHelper.writeXMLFile(out, mainNode);
            Object var5_3 = null;
            try {
                if (out != null) {
                    out.close();
                }
                break block11;
            }
            catch (IOException ignored) {
                Logger.getDefaultLog().warning("Error closing XML file");
            }
            break block11;
            {
                catch (IOException e) {
                    Logger.getDefaultLog().error("Error writing XML file");
                    Object var5_4 = null;
                    try {
                        if (out != null) {
                            out.close();
                        }
                        break block11;
                    }
                    catch (IOException ignored) {
                        Logger.getDefaultLog().warning("Error closing XML file");
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException ignored) {
                    Logger.getDefaultLog().warning("Error closing XML file");
                }
                throw throwable;
            }
        }
    }

    public static String writeXMLString(Node mainNode) {
        StringWriter w = new StringWriter(4095);
        XMLHelper.writeXMLFile(w, mainNode);
        return ((Object)w).toString();
    }

    public static void writeXMLFile(Writer out, Node mainNode) {
        try {
            DOMSource source = new DOMSource(mainNode);
            StreamResult result = new StreamResult(out);
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("indent", "yes");
            t.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            Logger.getDefaultLog().error("Error invoking XML parser");
        }
        catch (TransformerException e) {
            Logger.getDefaultLog().error("Error transforming XML file");
        }
    }

    public static String nodeText(Node n) {
        return XMLHelper.nodeText(n, new StringBuffer()).toString();
    }

    public static StringBuffer nodeText(Node n, StringBuffer text) {
        for (Node current = n.getFirstChild(); current != null; current = current.getNextSibling()) {
            if (current.getNodeValue() != null) {
                text.append(current.getNodeValue());
            }
            if (!current.hasChildNodes()) continue;
            XMLHelper.nodeText(current, text);
        }
        return text;
    }

    public static void printTree(Node n, int lvl) {
        int i;
        for (i = 0; i < lvl * 4; ++i) {
            System.out.print(" ");
        }
        Logger.getDefaultLog().log(n.getNodeName());
        NodeList nds = n.getChildNodes();
        for (i = 0; i < nds.getLength(); ++i) {
            XMLHelper.printTree(nds.item(i), lvl + 1);
        }
    }

    public static Element createNode(Document document, String nodeName) {
        return XMLHelper.createNode(document, nodeName, null);
    }

    public static Element createNode(Document document, String nodeName, Node parentNode) {
        return XMLHelper.createNode(document, nodeName, null, null, parentNode);
    }

    public static Element createNode(Document document, String nodeName, String attributeName, String attributeValue, Node parentNode) {
        Element newNode = document.createElement(nodeName);
        if (attributeName != null && attributeValue != null) {
            newNode.setAttribute(attributeName, attributeValue);
        }
        if (parentNode != null) {
            parentNode.appendChild(newNode);
        }
        return newNode;
    }

    public static Element createTextNode(Document document, String nodeName, String nodeText, Node parentNode) {
        Element newNode = XMLHelper.createNode(document, nodeName, parentNode);
        Text textNode = document.createTextNode(nodeText);
        newNode.appendChild(textNode);
        return newNode;
    }

    public static void main(String[] args) {
        Document d = XMLHelper.makeDocument(args[0]);
        if (args.length != 2) {
            XMLHelper.printTree(d, 0);
            return;
        }
        if (d != null) {
            Logger.getDefaultLog().log("Node search " + args[1] + "\nreturned " + XMLHelper.findNode(d, args[1]));
        }
    }
}

